<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * @package Razorpay :  CodeIgniter Razorpay Gateway
 *
 * @author TechArise Team
 *
 * @email  info@techarise.com
 *   
 * Description of Razorpay Controller
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Razorpay extends CI_Controller {
    // construct
    public function __construct() {
        parent::__construct();   
        // $this->load->model('Site', 'site');     
    }
    // index page
    public function index() {
        $data=db_variables();
        $data['title'] = 'Razorpay | TechArise';  
        // $data['productInfo'] = $this->site->getProduct();           

        $data['seo_title'] = 'Get Expert Beauty, Cleaning &amp; Repair Services at Home';
        $data['seo_description'] = "Get Expert Beauty, Cleaning &amp; Repair Services at Home";
        $data['seo_image'] = base_url('assets/avator/og_img.jpg');
        $data['seo_keywords'] = 'Get Expert Beauty, Cleaning &amp; Repair Services at Home';
        $data['page_name']='Ynaps.com';

        $this->load->view('inc/_header',$data);
        $this->load->view('razorpay/pay_raz.php', $data);
        $this->load->view('inc/_footer',$data);
    }
    
    // checkout page
    public function checkout($id) {
        $data=db_variables();
        $data['title'] = 'Checkout payment | TechArise';  
        // $this->site->setProductID($id);
        // $data['itemInfo'] = $this->site->getProductDetails(); 
        $data['return_url'] = site_url().'razorpay/callback';
        $data['surl'] = site_url().'razorpay/success';;
        $data['furl'] = site_url().'razorpay/failed';;
        $data['currency_code'] = 'INR';

        $this->load->view('inc/_header',$data);
        $this->load->view('razorpay/raz_check.php', $data);
        $this->load->view('inc/_footer',$data);
    }

    // initialized cURL Request
    private function get_curl_handle($payment_id, $amount)  {
        $url = 'https://api.razorpay.com/v1/payments/'.$payment_id.'/capture';
        $key_id = RAZOR_KEY_ID;
        $key_secret = RAZOR_KEY_SECRET;
        $fields_string = "amount=$amount";
        //cURL Request
        $ch = curl_init();
        //set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $key_id.':'.$key_secret);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        //curl_setopt($ch, CURLOPT_CAINFO, dirname(__FILE__).'/ca-bundle.crt');
        return $ch;
    }   
        
    // callback method
    public function callback() {
        if (!empty($this->input->post('razorpay_payment_id')) && !empty($this->input->post('merchant_order_id'))) {
            $razorpay_payment_id = $this->input->post('razorpay_payment_id');
            $merchant_order_id = $this->input->post('merchant_order_id');
            $currency_code = 'INR';
            $amount = $this->input->post('merchant_total');
            $merchant_order_id = $this->input->post('merchant_order_id');

            $email = $this->input->post('email');
            $chk_code = $this->input->post('chk_code');
            $ecom_order_name = $this->input->post('ecom_order_name');
            
            $success = false;
            $error = '';
            try {                
                $ch = $this->get_curl_handle($razorpay_payment_id, $amount);
                //execute post
                $result = curl_exec($ch);
                $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                if ($result === false) {
                    $success = false;
                    echo $error = 'Curl error: '.curl_error($ch);
                } else {
                    $response_array = json_decode($result, true);
                   //echo "<pre>";print_r($response_array);die;
                        //Check success response
                        if ($http_status === 200 and isset($response_array['error']) === false) {
                            $success = true;
                        } else {
                            $success = false;
                            if (!empty($response_array['error']['code'])) {
                                $error = $response_array['error']['code'].':'.$response_array['error']['description'];
                            } else {
                                $error = 'RAZORPAY_ERROR:Invalid Response <br/>'.$result;
                            }
                        }
                }
                //close connection
                curl_close($ch);
            } catch (Exception $e) {
                $success = false;
                $this->db->query("insert into cr_orders (or_orid,or_status,or_mid,or_amount,or_date_created,or_type) values ('$merchant_order_id','2','1','$amount',now(), '$or_type') ");
                $error = 'OPENCART_ERROR:Request to Razorpay Failed';
            }
            if ($success === true) {
                //echo "select * from `x-orders` where checkout_order_id='$merchant_order_id' ";
                $the_order_details=$this->db->query("select * from `x-orders` o,`x-orders-detail` od, `x-products` where o.checkout_order_id='$merchant_order_id' and o.checkout_order_id=od.checkout_order_id and od.xod_pid=pid");
                $the_all_detailsa=$the_order_details->result_array();
                //print_r($the_all_detailsa);
                $pemail=array();
                $prods=array();
                $providers=array();
                
                $timesCHK = false;
                $timesText = "";
                foreach($the_all_detailsa as $the_all_detail){
                    if ($timesCHK==false) {
                        $timesText = "Date : ".date('D jS M Y',strtotime($the_all_detail['chk_user_date']));
                        $timesCHK = true;
                    }
                    $theuser_email=trim($the_all_detail['email']);
                    $theuser_phone=trim($the_all_detail['phone']);
                    $thepr_email=trim($the_all_detail['provider_email']);
                    $discount_code=trim($the_all_detail['discount_code']);
                    array_push($pemail, $thepr_email);
                    $prod="<br/>Description: ".$the_all_detail['xod_title']."<br/>Name: ".$the_all_detail['xod_name']."<br/>Qty: ".$the_all_detail['xod_qty']."<br/>Price: INR ".number_format($the_all_detail['xod_price'],2);
                    array_push($prods, $prod);
                    // $provider="<br/>Provider Restaurant Name: ".$the_all_detail['provider_restu_name']."<br/>Provider Email: ".$the_all_detail['provider_email']."<br/>Provider Phone: ".$the_all_detail['provider_phone']."<br/>Provider Address: ".$the_all_detail['provider_address'];
                    array_push($providers, $provider);
                }
                $punq_email=array_unique($pemail);
                //$pr_emails=@implode(", ", $punq_email);
                //print_r($prods);
                $prod_details=@implode("<br/>", $prods);
                $prov_details=@implode("<br/>", $providers);
                //echo 'email: '.$theuser_email;
                
                $this->db->query("update `x-orders` set chk_payment_status='1' where checkout_order_id='$merchant_order_id' ");
                $this->db->query("insert into cr_orders (or_orid, or_status, or_mid,or_amount,or_date_created,or_type) values ('$merchant_order_id','1','1','$amount',now(), '$or_type')");          

                $site_details=db_variables();
        $site_brief=$site_details['site_brief'];
        $site_name=$site_details['site_name'];
        $site_email=$site_details['site_email'];
        $site_address=$site_details['site_address'];

        $emaillist_act=array("$theuser_email","$site_email");
        $json_string = array( 'to' =>$emaillist_act,'category' => 'signup-form');
        $tos="$theuser_email";
        $subject09="Order placed successfully #$merchant_order_id";
        $preheader="You have successfully checkout for the Products";
        $greet="Hi, $ecom_order_name";
        $message="Thank you for the Order. <br/> your Voucher code for your order is #<b>$chk_code</b>";
        $message.="<br/><br/>Your Order Details: <br>".$prod_details;
        $message.="<br/>Provider Details: <br/>".$prov_details;

        $message.= "<br/><br/>".$timesText;

        $link=base_url();
        $linkname='Browse Website';
        $message2="$site_brief";
        $greet2='Thank you so much';
        $myName_emailis="Membership";
        $messageto90=email_template($preheader,$greet,$message,$link,$linkname,$message2,$greet2,$site_name,$site_address);
        send_email($tos,$subject09,$messageto90,$site_name,$json_string);    
//Provider Emails
        if(count($punq_email)>'0'){
        foreach($punq_email as $pq_email){
            $emaillist_act=array("$site_email");
            array_push($emaillist_act, $pq_email);
        
            //print_r($emaillist_act);
            $json_string = array( 'to' =>$emaillist_act,'category' => 'signup-form');
            $tos="$pq_email";
            $subject09="Order received #$merchant_order_id";
            $preheader="You have successfully checkout for the Products";
            $greet="Hi, ";
            $message="Congratulations, you receive an Order.<br/> Voucher code for order is #<b>$chk_code</b> <br/> Customer Details: <br/>";
            $message.="Name: $ecom_order_name <br/> Email: $theuser_email<br/>Phone: $theuser_phone<br/>Coupan code: $discount_code";

            $message.= "<br/><br/>".$timesText;

            $link=base_url();
            $linkname='Browse Website';
            $message2="$site_brief";
            $greet2='Thank you so much';
            $myName_emailis="Membership";
            $messageto90=email_template($preheader,$greet,$message,$link,$linkname,$message2,$greet2,$site_name,$site_address);
            send_email($tos,$subject09,$messageto90,$site_name,$json_string);    
        }//foreach
        }

                if(!empty($this->session->userdata('ci_subscription_keys'))) {
                    $this->session->unset_userdata('ci_subscription_keys');
                 }
                if (!$order_info['order_status_id']) {
                    $this->db->query("insert into cr_orders (or_orid,or_status,or_mid,or_amount,or_date_created,or_type) values ('$merchant_order_id','5','1','$amount',now(), '$or_type') ");
                    redirect($this->input->post('merchant_surl_id'));
                } else {
                    $this->db->query("insert into cr_orders (or_orid,or_status,or_mid,or_amount,or_date_created,or_type) values ('$merchant_order_id','6','1','$amount',now(), '$or_type') ");
                    redirect($this->input->post('merchant_surl_id'));
                }

            } else {
                
                $this->db->query("update `x-orders` set chk_payment_status='1' where checkout_order_id='$merchant_order_id' ");

                $this->db->query("insert into cr_orders (or_orid,or_status,or_mid,or_amount,or_date_created, or_type) values ('$merchant_order_id','3','1','$amount',now(), '$or_type') ");                

                redirect($this->input->post('merchant_furl_id'));
            }
        } else {
            $this->db->query("insert into cr_orders (or_orid,or_status,or_mid,or_amount,or_date_created, or_type) values ('$merchant_order_id','0','1','$amount',now(), '$or_type') ");
            echo 'An error occured. Contact site administrator, please!';
        }
    }


    public function success() {
        $data['title'] = 'Razorpay Success | TechArise';  
        $this->load->view('razorpay/success', $data);
    }  
    public function failed() {
        $data['title'] = 'Razorpay Failed | TechArise';            
        $this->load->view('razorpay/failed', $data);
    } 
}
?>