<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\CommitteeModel;
use App\Models\SettingsModel;
use App\Models\SeoModel;
use App\Models\ProgramModel;



class ScientificCommittee extends BaseController
{
  
    public $committeeModel;
    public $settingsModel;
    public $session;
    public $seoModel;
    public $ProgramModel;

    public function __construct()
    {
        helper('form');
      
        $this->committeeModel = new CommitteeModel();
        $this->settingsModel  = new SettingsModel();
        $this->session = session();
        $this->seoModel = new SeoModel();
        $this->ProgramModel = new ProgramModel();
        
    }
    public function index()
    {
        $data['scientific_committee'] = $this->committeeModel->where('status','1')->orderBy("id", "desc")->findall();   
        $data['settings'] = $this->settingsModel->find(1);
        $data['meta_content'] = $this->seoModel->find(10);
$data['programs'] = $this->ProgramModel->find(); 
        echo view('scientific_committee',$data);
    }  
    public function member($url)
    {
        $data['member_details'] = $this->committeeModel->where('url',$url)->find();   
        $data['settings'] = $this->settingsModel->find(1);
        $data['meta_content'] = $this->seoModel->find(10);
$data['programs'] = $this->ProgramModel->find(); 
        echo view('scientific_member',$data);
    }

    
}
