<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\CategoryModel;
use App\Models\SettingsModel;
use App\Models\ConferenceGalleryModel;
use App\Models\ContentModel;
use App\Models\PastProceedingsModel;
use App\Models\ConferenceModel;
use App\Models\ConferenceSpeakersModel;
use App\Models\SeoModel;
use App\Models\PastCoferenceUsersModel;
use App\Models\ConferenceVideosModel;
use App\Models\ProgramModel;

class PastConferences extends BaseController
{
   
    public $conferenceGalleryModel;
    public $categoryModel;
    public $settingsModel;
    public $contentModel;
    public $session;
    public $pastProceedingsModel;
    public $conferenceModel;
    public $conferenceSpeakersModel;
    public $seoModel;
    public $pastCoferenceUsersModel;
    public $conferenceVideosModel;
	public $ProgramModel;

    public function __construct()
    {
        helper('form');
       // helper('captcha');
       $this->conferenceGalleryModel = new ConferenceGalleryModel();
       $this->categoryModel = new CategoryModel();
       $this->settingsModel = new SettingsModel();
       $this->contentModel= new ContentModel();
       $this->session = session();
       $this->pastProceedingsModel = new PastProceedingsModel();
       $this->conferenceModel = new ConferenceModel();
       $this->conferenceSpeakersModel = new ConferenceSpeakersModel();
       $this->seoModel = new SeoModel();
       $this->pastCoferenceUsersModel = new PastCoferenceUsersModel();
       $this->conferenceVideosModel = new ConferenceVideosModel();
	   $this->ProgramModel = new ProgramModel();
       $this->validation = \Config\Services::validation();

    }
    public function index()
    {
        $data['settings'] = $this->settingsModel->find(1);
        $data['conferences'] = $this->conferenceModel->find();
        $data['meta_content'] = $this->seoModel->find(7);
		$data['programs'] = $this->ProgramModel->find(); 

        echo view('past_conferences',$data);
        
    }
   public function gallery()
   {
    $data['gallery'] = $this->conferenceGalleryModel->orderBy("id", "desc")->findall();   
    $data['settings'] = $this->settingsModel->find(1);
    $data['meta_content'] = $this->seoModel->find(7);
	$data['programs'] = $this->ProgramModel->find(); 

    echo view('past_conference_gallery',$data);
   }
   public function report()
   {
    $data['settings'] = $this->settingsModel->find(1);
    $data['report_data'] = $this->contentModel->find(63); 
    $data['meta_content'] = $this->seoModel->find(7);
	$data['programs'] = $this->ProgramModel->find(); 

    echo view('past_conference_report',$data);
   }
   public function proceedings()
   {
    $data['settings'] = $this->settingsModel->find(1);
    $data['proceedings'] = $this->pastProceedingsModel->orderBy("id", "desc")->findall();   
    $data['meta_content'] = $this->seoModel->find(7);
$data['programs'] = $this->ProgramModel->find(); 
    echo view('past_conference_proceedings',$data);
   }
   public function speakers($url)
   {
    $conferences_id = $this->conferenceModel->where('url',$url)->get()->getRowArray();
    $id = $conferences_id['id'];
    $data['settings'] = $this->settingsModel->find(1);
    $data['speakers'] = $this->conferenceSpeakersModel->where('conference_id',$id)->orderBy("id", "desc")->findall();   
    $data['meta_content'] = $this->seoModel->find(7);
$data['programs'] = $this->ProgramModel->find(); 
    echo view('past_conference_speakers',$data);
   }
   public function speaker_details($url)
   {
   
    $data['settings'] = $this->settingsModel->find(1);
    $data['speaker_detailss'] = $this->conferenceSpeakersModel->where('url',$url)->orderBy("id", "desc")->findall();   
    $data['meta_content'] = $this->seoModel->find(7);
$data['programs'] = $this->ProgramModel->find(); 
    echo view('speaker_details',$data);
   }
   public function cust_login()
   {
    if($this->request->getMethod() == "post")
    {
        $email = $this->request->getVar('email');
        $password = $this->request->getVar('password');
                        
             $userdata = $this->pastCoferenceUsersModel->verifyEmail($email,$password);
            
             if($userdata != 0)
             {               
                $this->session->set('user_login',$userdata['id']);
                $this->session->set('email',$userdata['email_id']);
                $this->session->set('name',$userdata['username']);
                return redirect()->to(base_url().'/conference-videos');                
            }
    }
    $data['settings'] = $this->settingsModel->find(1);

    echo view('cust_login',$data);
   }
   
   public function video_register()
    {
        if($this->request->getMethod() == 'post')
        {
            $data = $this->request->getVar();
            $data['created_at'] = date('Y-m-d');
            if($this->pastCoferenceUsersModel->insert($data))
             {
                $this->session->setTempData('success_reg','Successfully registered, please login',3);
                return redirect()->to(base_url().'/coference-login');
             }
        }
        $data['settings'] = $this->settingsModel->find();

        echo view('video_register',$data);
    }
    public function video_page()
    {
        $data['settings'] = $this->settingsModel->find();
        $data['conf_videos'] = $this->conferenceVideosModel->orderBy("id", "desc")->findall();   

        echo view('video_page',$data);
    }
    public function video_play($id)
    {
        if(!session()->has('user_login'))
        {
            $current_url = current_url(true);
            $this->session->set('redirect_url', $current_url);
            return redirect()->to(base_url()."/coference-login");
        }
        $data['settings'] = $this->settingsModel->find();
        $data['conf_videos'] = $this->conferenceVideosModel->where("id",$id)->get()->getRowArray();   
        $data['conf_videos_list'] = $this->conferenceVideosModel->orderBy("id", "desc")->findall();   

        echo view('video_play',$data);
    }
    public function forgot_pwd()
    {
        if($this->request->getMethod() == 'post')
      {
        $rules = [
         
          'email'=>[
            'rules' =>'required|valid_email',
            'errors' => [
                'required' =>'Email is Required',
                'valid_email' => 'Please Enter Valid Email ID',
                
            ],
        ],
          
      ];
      $validation_message = $this->validate($rules);
      if(!$validation_message)
      {
        $data['settings'] = $this->settingsModel->find(1);
        $data['errors'] = $this->validation->getErrors();
        
        return view('conf_forgot_password',$data);
      }
     else
     {
         $emailid = $this->request->getVar('email');
         $user_info = $this->pastCoferenceUsersModel->where('email_id',$emailid)->find();

          //print_r($user_info);exit;     
        //if($email == $user_data['email'])
        if(count($user_info) != 0)
        {
          foreach($user_info as $user_data);
          $mail_password = bin2hex(openssl_random_pseudo_bytes(3));
          //$db_pass['password']  = password_hash($mail_password,PASSWORD_DEFAULT);
          $db_pass['password'] = $mail_password;
          $id = $user_data['id'];
          if($this->pastCoferenceUsersModel->update($id,$db_pass) == true)
          {        
           // $this->session->setTempData('success','Password Sent to your mail id '.$mail_password,3);
              include_once FCPATH . "vendor/sendmail/vendor/autoload.php";
              $API_KEY="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";

              $email = new \SendGrid\Mail\Mail(); 
              $email->setFrom("srikanth@prodigit.in", "Linkinsciences");
              $email->setSubject("New Password From Linkinsciences");
              $email->addTo($emailid,$user_data['username']);
              $email->addContent("text/plain", "Password Sent to your mail id");
              $email->addContent(
                  "text/html", "<strong>Your Linkinsciences Pastconferences New Password is : ".$mail_password."</strong>"
              );
              $apiKey = ($API_KEY);
              $sendgrid = new \SendGrid($apiKey);                    
             
              if($sendgrid->send($email))
              {
                $this->session->setTempData('success_reg','Your password is sent to your registered email id ',1);
                return redirect()->to(base_url().'/coference-login');

              }


          }
        }
        else
        {
          $this->session->setTempdata('error',"Sorry! entered email id doesn't exist",3);
          return redirect()->to(current_url());
        }  
      }
           
      }

        $data['settings'] = $this->settingsModel->find();

        echo view('conf_forgot_password',$data);
    }
    public function logout()
    {
        session()->remove('user_login');
        session()->destroy();
        return redirect()->to(base_url()."/conference-videos");
    }
   

   
    
    

    
}
