<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\HomeBannerModel;
use App\Models\ContentModel;
use App\Models\ExhibitorsModel;
use App\Models\SettingsModel;
use App\Models\RenewedSpeakersModel;
use App\Models\ConferencesModel;
use App\Models\CommitteeModel;
use App\Models\SessionsModel;
use App\Models\CategoryModel;
use App\Models\TestmonialModel;
use App\Models\BrochuresModel;
use App\Models\RegistrationDate;
use App\Models\RegistrationTypeModel;
use App\Models\ConferenceModel;
use App\Models\ContactModel;
use App\Models\VenueModel;
use App\Models\VenueGalleryModel;
use App\Models\HotelGalleryModel;
use App\Models\SeoModel;
use App\Models\CountriesModel;
use App\Models\ImportantDatesModel;
use App\Models\ProgramModel;
use App\Models\SpeakerCategoryModel;
use App\Models\ProgramSpeakersDataModel;

class Home extends BaseController
{
    public $blogModel;
    public $hModel;
    public $contentModel;
    public $exhibitorsModel;
    public $settingsModel;
    public $renewedSpeakersModel;
    public $session;
    public $conferencesModel;
    public $committeeModel;
    public $sessionsModel;
    public $categoryModel;
    public $brochuresModel;
    public $registrationDate;
    public $registrationTypeModel;
    public $conferenceModel;
    public $venueModel;
    public $venueGalleryModel;
    public $hotelGalleryModel;
    public $seoModel;
    public $countriesModel;    
    public $testmonialModel;
    public $contactModel;
    public $importantDatesModel;
	public $ProgramModel;
	public $ProgramSpeakersDataModel;

    public function __construct()
    {
        helper('form');
       // helper('captcha');
        $this->hModel = new HomeBannerModel();
        $this->contentModel= new ContentModel();
        $this->exhibitorsModel = new ExhibitorsModel();
        $this->settingsModel  = new SettingsModel();
        $this->renewedSpeakersModel = new RenewedSpeakersModel();
        $this->session = session();
        $this->conferencesModel = new ConferencesModel();
        $this->committeeModel = new CommitteeModel();
        $this->sessionsModel = new SessionsModel();
        $this->categoryModel = new CategoryModel();
        $this->brochuresModel = new BrochuresModel();
        $this->registrationDate = new RegistrationDate();
        $this->registrationTypeModel = new RegistrationTypeModel();
        $this->conferenceModel = new ConferenceModel();
        $this->venueModel = new VenueModel();
        $this->venueGalleryModel = new VenueGalleryModel();
        $this->hotelGalleryModel = new HotelGalleryModel();
        $this->testmonialModel = new TestmonialModel();
        $this->contactModel = new ContactModel();
        $this->seoModel = new SeoModel();
        $this->countriesModel = new CountriesModel();
        $this->importantDatesModel = new ImportantDatesModel();
		$this->ProgramModel = new ProgramModel();
		$this->ProgramSpeakersDataModel = new ProgramSpeakersDataModel();
        
        
    }
    public function index()
    {
     // print_r($_POST);
       
       $data['homebanner'] = $this->hModel->find(); 
       $data['about_content'] = $this->contentModel->find(18); 
       $data['settings'] = $this->settingsModel->find(1);
       $data['exhibitors'] = $this->exhibitorsModel->orderBy("id", "asc")->findall();   
       $data['renewed_speaker'] = $this->renewedSpeakersModel->orderBy("id", "desc")->findall(); 
       $data['scientific_committee'] = $this->committeeModel->limit(8,0)->get()->getResultArray();   
       $data['scientific_heading'] = $this->contentModel->find(13); 
       $data['scientific1'] = $this->contentModel->find(14); 
       $data['scientific2'] = $this->contentModel->find(15); 
       $data['scientific3'] = $this->contentModel->find(16); 
       $data['scientific4'] = $this->contentModel->find(17); 
       $data['scientific5'] = $this->contentModel->find(61); 
       $data['awards'] = $this->contentModel->find(1); 
       $data['awards1'] = $this->contentModel->find(62); 
       $data['home_testmonials'] = $this->testmonialModel->find(); 
       $data['scientific_sessions'] = $this->sessionsModel->orderBy("id", "asc")->findall();   
       $data['categories'] = $this->categoryModel->orderBy("id", "desc")->where('media_type','Media Partner')->find();
       $data['categories1'] = $this->categoryModel->orderBy("id", "desc")->where('media_type','Sponsor')->find();
       $data['categories2'] = $this->categoryModel->orderBy("id", "desc")->where('media_type','Exhibitor')->find();
       $data['brochures'] = $this->brochuresModel->find(1);   
       $data['reg_dates'] = $this->registrationDate->find(1);   
       $data['registration_type'] = $this->registrationTypeModel->find(1);   
       $data['conferences'] = $this->conferenceModel->find();
       $data['meta_content'] = $this->seoModel->find(1);
       $data['contact_us'] = $this->contentModel->find(34); 
       $data['important_dates'] = $this->importantDatesModel->find(1);
       $data['country_list'] = $this->countriesModel->orderBy("name", "asc")->findall();            
       $data['programs'] = $this->ProgramModel->find(); 
        echo view('index',$data);
        
    }
    public function viewConferenceDetails()
    {
        $id = $this->request->getVar('id');
        $conferences = $this->conferencesModel->find($id);   
       // print_r($conferences);
       $data['meta_content'] = $this->seoModel->find(1);

        echo $conferences['conference_description'];

    }
    public function venue()
    {
            $data['settings'] = $this->settingsModel->find(1);
       $data['homebanner'] = $this->hModel->find(); 
       $data['venue_content'] = $this->venueModel->find(); 
       $venue = $this->venueModel->where('status',1)->find(); 
        foreach($venue as $vdata);
       $data['venue_gallery'] = $this->venueGalleryModel->where('venue_id',$vdata['id'])->find(); 
       $data['hotel_gallery'] = $this->hotelGalleryModel->where('venue_id',$vdata['id'])->find(); 
       $data['meta_content'] = $this->seoModel->find(6);
       
       
       echo view('venue',$data);
    }
   
    
}
