<?php

namespace Config;
use App\Models\SettingsModel;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');

//$routes->add('about','Home::about');

$routes->get('/sitemap', 'Home::sitemap');

$routes->get('/abstractdetails', 'PastConferences::abstractDetailsPage');

$routes->get('/dashboard/changeSpeakerDay', 'Dashboard::changeSpeakerDay');

$routes->get('/dashboard/deleteprogrampile', 'Dashboard::deleteProgramFile');

$routes->get('/dashboard/abstractpage', 'Dashboard::abstractPage');
$routes->get('/dashboard/abstractpage/addnew', 'Dashboard::addAbstractPage');
$routes->get('dashboard/abstractpage/(:num)/edit', 'Dashboard::editAbstractPage/$1');
$routes->get('dashboard/abstractpage/(:num)/delete', 'Dashboard::deleteAbstractPage/$1');


//Associative array for routes
$myroutes = [];
$myroutes['scientific-committee'] = 'ScientificCommittee::index';
$myroutes['scientific-committee/(:any)'] = 'ScientificCommittee::indexYears/$1';

$myroutes['member-details/(:any)'] = 'ScientificCommittee::member/$1';
$myroutes['program-details/(:any)']='Programs::details/$1';
$myroutes['venue']='Home::venue';
$myroutes['coference-login']='PastConferences::cust_login';
$myroutes['coference-logout']='PastConferences::logout';

$myroutes['conference-video-register']='PastConferences::video_register';
$myroutes['conference-videos']='PastConferences::video_page';

$myroutes['exhibitor-sponsorship']='Register::exhibitor_sponsorship';
$myroutes['registration']='Register::dollar';
$myroutes['registration/(:any)']='Register::index/$1';
$myroutes['registration-guidelines']='Register::registration_guidelines';

$myroutes['past-conferences-gallery']='PastConferences::gallery';
$myroutes['past-conferences']='PastConferences::index';
$myroutes['past-conferences-report']='PastConferences::report';
$myroutes['past-conferences-proceedings']='PastConferences::proceedings';

$myroutes['past-conferences-proceedings/(:any)']='PastConferences::proceedingsbyyear/$1';

$myroutes['past-conferences-speakers/(:any)']='PastConferences::speakers/$1';
$myroutes['past-conferences-video/(:any)']='PastConferences::video_play/$1';
$myroutes['past-conference-forgot-password-page']='PastConferences::forgot_pwd';

$myroutes['speaker-details/(:any)']='PastConferences::speaker_details/$1';



$myroutes['abstract']='Contactus::abstract';




$myroutes['register/(:alpha)/(:num)']='Sample::create/$1/$2';

$routes->map($myroutes);

$routes->set404Override(function(){
	//Errors
	$settingsModel = new SettingsModel();
	
	
    $data['settings'] = $settingsModel->find(1);
    echo view('errors/custom-errors', $data);
});


/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
