<?php

namespace App\Controllers;

use \CodeIgniter\Controller;
use App\Models\ContactModel;
use App\Models\ProgramsModel;
use App\Models\ProgramModel;
use App\Models\SpeakerCategoryModel;
use App\Models\ProgramSpeakersDataModel;
use App\Models\DashboardModel;
use App\Models\ContentModel;
use App\Models\HomeBannerModel;
use App\Models\SettingsModel;
use App\Models\ConferenceGalleryModel;
use App\Models\ExhibitorsModel;
use App\Models\ConferencesModel;
use App\Models\ConferenceModel;
use App\Models\CommitteeModel;
use App\Models\SessionsModel;
use App\Models\PastProceedingsModel;
use App\Models\RenewedSpeakersModel;
use App\Models\BrochuresModel;
use App\Models\AbstractModel;
use App\Models\RegistrationTypeModel;
use App\Models\RegGuidelinesModel;
use App\Models\AddOnsModel;
use App\Models\RegistrationDate;
use App\Models\ConferenceSpeakersModel;
use App\Models\RegisterSubmitModel;
use App\Models\VenueModel;
use App\Models\VenueGalleryModel;
use App\Models\HotelGalleryModel;
use App\Models\CountriesModel;
use App\Models\SeoModel;
use App\Models\BlogModel;
use App\Models\CouponsModel;
use App\Models\ConferenceVideosModel;
use App\Models\CareersModel;
use App\Models\TestmonialModel;
use App\Models\CategoryModel;
use App\Models\PastCoferenceUsersModel;
use App\Models\ImportantDatesModel;
use App\Models\BrochureDownloadedUsersModel;
use App\Models\SponsorshipModel;
use App\Models\AbstractpageModel;

class Dashboard extends Controller
{
    public $dModel;
    public $hModel;
    public $contentModel;
    public $settingsModel;
    public $programModel;
    public $programsModel;
    public $speakerCategoryModel;
    public $programSpeakersDataModel;
    public $testmonialModel;
    public $conferenceGalleryModel;
    public $exhibitorsModel;
    public $conferencesModel;
    public $conferenceModel;
    public $committeeModel;
    public $sessionsModel;
    public $pastProceedingsModel;
    public $renewedSpeakersModel;
    public $brochuresModel;
    public $abstractModel;
    public $registrationTypeModel;
    public $regGuidelinesModel;
    public $addOnsModel;
    public $registrationDate;
    public $conferenceSpeakersModel;
    public $registerSubmitModel;
    public $countriesModel;
    public $venueModel;
    public $venueGalleryModel;
    public $hotelGalleryModel;
    public $seoModel;
    public $careersModel;    
    public $categoryModel;
    public $blogModel;
    public $couponsModel;
    public $conferenceVideosModel;
    public $pastCoferenceUsersModel;
    public $importantDatesModel;
    public $brochureDownloadedUsersModel;
    public $sponsorshipModel;
	public $abstractpageModel;


    public function __construct()
    {
        helper('form');
        helper('url');
        $this->dModel = new DashboardModel();
        $this->hModel = new HomeBannerModel();
        $this->contactModel = new ContactModel();
        $this->contentModel= new ContentModel();
        $this->settingsModel  = new SettingsModel();
        $this->programModel = new ProgramModel();
        $this->programsModel = new ProgramsModel();
        $this->speakerCategoryModel = new SpeakerCategoryModel();
        $this->programSpeakersDataModel = new ProgramSpeakersDataModel();
        $this->conferenceGalleryModel = new ConferenceGalleryModel();
        $this->exhibitorsModel = new ExhibitorsModel();
        $this->conferencesModel = new ConferencesModel();
        $this->conferenceModel = new ConferenceModel();
        $this->committeeModel = new CommitteeModel();
        $this->sessionsModel = new SessionsModel();
        $this->pastProceedingsModel = new PastProceedingsModel();
        $this->renewedSpeakersModel = new RenewedSpeakersModel();
        $this->brochuresModel = new BrochuresModel();
        $this->abstractModel = new AbstractModel();
        $this->registrationTypeModel = new RegistrationTypeModel();
        $this->regGuidelinesModel = new RegGuidelinesModel();        
        $this->addOnsModel = new AddOnsModel();
        $this->registrationDate = new RegistrationDate();
        $this->conferenceSpeakersModel = new ConferenceSpeakersModel();
        $this->registerSubmitModel = new RegisterSubmitModel();
        $this->countriesModel = new CountriesModel();
        $this->seoModel = new SeoModel();
        $this->blogModel = new BlogModel();
        $this->venueModel = new VenueModel();
        $this->venueGalleryModel = new VenueGalleryModel();
        $this->hotelGalleryModel = new HotelGalleryModel();
        $this->couponsModel = new CouponsModel();
        $this->careersModel = new CareersModel();        
        $this->testmonialModel = new TestmonialModel();
        $this->categoryModel = new CategoryModel();
        $this->conferenceVideosModel = new ConferenceVideosModel();
        $this->pastCoferenceUsersModel = new PastCoferenceUsersModel();
        $this->importantDatesModel = new importantDatesModel();
        $this->brochureDownloadedUsersModel = new BrochureDownloadedUsersModel();
        $this->sponsorshipModel = new SponsorshipModel();
		$this->abstractpageModel = new AbstractpageModel();

    }
    public function index()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['settings'] = $this->settingsModel->find(1);
        return view('admin/dashboardview',$data);
    }
    public function logout()
    {
        session()->remove('logged_user');
        session()->destroy();
        return redirect()->to(base_url()."/Admin");
    }

    //home banner operations
    public function viewBanner()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['banner'] = $this->hModel->orderBy("id", "asc")->findall();   
       $data['settings'] = $this->settingsModel->find(1);
        echo view('admin/bannerview',$data);
        
    }
    public function addBanner()
    {
        $data = [];
        $data['validation'] = null; 
         if($this->request->getMethod() == 'post')
        {
                $file = $this->request->getFile('banner');
				
               
                    $data = $this->request->getVar();
                    if($_FILES['banner']['name'] != '')
                    {
                        if(isset($_FILES['banner']))
                        {
                            $newName = $file->getRandomName();
                            $file->move(FCPATH.'public/uploads/',$newName);
                        }
                    }
                    $data['banner'] = $newName;

                            if($this->hModel->insert($data))
                            {
                                session()->setTempdata('success','Banner added successfully',3);
                                return redirect()->to(base_url()."/dashboard/viewBanner");
                            }              
           
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        
         echo view('admin/addBanner',$data);
        
    }
    public function editBanner($id=null)
    {
        $data['banner'] = $this->hModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $old_banner = $data['banner']['banner'];
            $file = $this->request->getFile('banner');

            if($_FILES['banner']['name'] != '')
            {
                if(isset($_FILES['banner']))
                {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/uploads/',$newName);
                }                
            } 
             else
             {
                $newName = $old_banner;
             }
             $data = $this->request->getVar();
             $data['banner'] = $newName;
             $data['updated_at'] = $date;
             if($this->hModel->update($id,$data) == true)
             {
               session()->setTempdata('success','Banner Updated',2);
               return redirect()->to(base_url()."/dashboard/viewBanner");
             }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->hModel->find($id);
        echo view('admin/editBanner',$data);
    }
    public function deleteBanner($id=null)
    {
        if($this->hModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewBanner");
        }
    }

    //Exhibitors

    public function viewExhibitors()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['exhibitors'] = $this->exhibitorsModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewExhibitors',$data);
    }
    
    public function addExhibitors()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
       
        if($this->request->getMethod() == 'post')
        {
                $data = $this->request->getVar();          
                $file = $this->request->getFile('image');
                    if($_FILES['image']['name'] != '')
                    {
                        if(isset($_FILES['image']))
                        {
                            $newName = $file->getRandomName();
                            $file->move(FCPATH.'public/uploads/',$newName);
                            //$data['image'] = $newName;
                        }
                    }
                    $data['image'] = $newName;
                    $data['created_at'] = $date;
                       
                         
                       // print_r($data);exit;
                            if($this->exhibitorsModel->insert($data))
                            {
                                session()->setTempdata('success','Exhibitor added successfully',3);
                                return redirect()->to(base_url()."/dashboard/viewExhibitors");
                            }
                      
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addExhibitors',$data);
    }

    public function editExhibitors($id=null)
    {
        $service_img = $this->exhibitorsModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data = $this->request->getVar();
            $old_service_img = $service_img['image'];
            $file = $this->request->getFile('image');

            if($_FILES['image']['name'] != '')
            {
                if(isset($_FILES['image']))
                {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/uploads/',$newName);    
                }
                
            } 
            else
                {
                   $newName = $old_service_img;
                }

           
            
             
              $data['image']=$newName;
              $data['url']=url_title($this->request->getVar('title'));
              $data['updated_at']=$date;
       
            
                //print_r($data);exit;
                 if($this->exhibitorsModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Exhibitor Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewExhibitors");
                    }
            
       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->exhibitorsModel->find($id);
        echo view('admin/editExhibitors',$data);
    }
    public function deleteExhibitors($id=null)
    {
        if($this->exhibitorsModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewExhibitors");
        }
    }


    //Testmonials Operations


    public function viewTestimonial()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

       $data['testmonials'] = $this->testmonialModel->findAll();


        return view('admin/viewTestmonial',$data);
    }
    public function addTestmonial()
    {
        $data = [];
        $data['validation'] = null; 
        if($this->request->getMethod() == 'post')
        {
            $file = $this->request->getFile('image');
			
                    
                    $data = $this->request->getVar();
                    if($_FILES['image']['name'] != '')
                    {
                        if(isset($_FILES['image']))
                        {
                            $newName = $file->getRandomName();
                            $file->move(FCPATH.'public/testmonials/',$newName);
                        }
                    }
                    $data['image'] = $newName;

                   
                            if($this->testmonialModel->insert($data))
                            {
                                session()->setTempdata('success','Testmonials added successfully',3);
                                return redirect()->to(base_url()."/dashboard/viewTestimonial");
                            }
                       
               
           
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        echo view('admin/addTestmonial',$data);
        
    }
    public function editTestmonial($id)
    {
        $image = $this->testmonialModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data = $this->request->getVar();
           // print_r($data);exit;
            $old_banner = $image['image'];
            $file = $this->request->getFile('image');            
            
                if(isset($_FILES['image']))
                {
                    if($_FILES['image']['name'] != '')
                    {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/testmonials/',$newName);      
                                                 
                } 
                else
                {
                    $newName = $old_banner;
                }
                
            $data['image'] = $newName;
             //print_r($data); exit;
                 if($this->testmonialModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Testmonial Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewTestimonial");
                    }
                }

       
    }
    if(!session()->has('logged_user'))
    {
        return redirect()->to(base_url()."/admin");
    }
    $uniid = session()->get('logged_user');
    $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

    $data['edit_data']=$this->testmonialModel->find($id);

    echo view('admin/editTestmonial',$data);
}

    public function deleteTestmonial($id=null)
    {
        if($this->testmonialModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewTestimonial");
        }
    }
    //Exhibitors Enquiries
    
    public function ViewsponsorshipEnq()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['sponsor'] = $this->sponsorshipModel->orderBy('id','desc')->findAll();

        return view('admin/ViewsponsorshipEnq',$data);        
    }
    public function deleteSponsorshipEnq($id=null)
    {
        if($this->sponsorshipModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/ViewsponsorshipEnq");
        }
    }
    public function deleteall_sponsership_enq()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->sponsorshipModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/ViewsponsorshipEnq");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/ViewsponsorshipEnq");
            }

        }
    }


    //Broucher users
    
    public function viewBroucherUsers()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['contact'] = $this->brochureDownloadedUsersModel->orderBy('id','desc')->findAll();

        return view('admin/viewBroucherUsers',$data);        
    }
    public function deleteBroucherUsers($id=null)
    {
        if($this->brochureDownloadedUsersModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/viewBroucherUsers");
        }
    }
    public function deleteall_broucher_users_enq()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->brochureDownloadedUsersModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/viewBroucherUsers");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewBroucherUsers");
            }

        }
    }

    //all contact from Operations
    public function viewContacts()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['contact'] = $this->contactModel->orderBy('id','desc')->findAll();

        return view('admin/viewContact',$data);        
    }
    public function deleteContact($id=null)
    {
        if($this->contactModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/viewContacts");
        }
    }
    public function deleteall_contact_enq()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->contactModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/viewContacts");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewContacts");
            }

        }
    }


    
    //abstract
    public function viewAbstract()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['abstracts'] = $this->abstractModel->orderBy('id','desc')->findAll();
        return view('admin/viewAbstract',$data);
        
    }
    public function deleteAbstract($id=null)
    {
        if($this->abstractModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/viewAbstract");
        }
    }
    public function deleteall_abstract_enq()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->abstractModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/viewAbstract");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewAbstract");
            }

        }
    }
    

    //registerations 
    public function viewRegistrations()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['registration_users'] = $this->registerSubmitModel->orderBy('id','desc')->findAll(); 
        return view('admin/viewRegistrations',$data);
        
    }
    public function deleteRegistrations($id=null)
    {
        if($this->registerSubmitModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/viewRegistrations");
        }
    }
    public function deleteall_registered_enq()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->registerSubmitModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/viewRegistrations");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewRegistrations");
            }

        }
    }
    
     //Products Operations


     public function viewPrograms()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['programs'] = $this->programsModel->orderBy("id", "desc")->findall();   
        
 
         return view('admin/viewPrograms',$data);
     }
     
     public function addPrograms()
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
        
         if($this->request->getMethod() == 'post')
         {
           
            $data = $this->request->getVar();
            
            $data['url'] = url_title($this->request->getVar('program_name'));
            
            $data['created_at'] = $date;
            if($this->programsModel->insert($data))
            {
                session()->setTempdata('success','Program added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewPrograms");
            }
                       
         }
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall(); 
 
         return view('admin/addPrograms',$data);
     }
 
     public function editPrograms($id=null)
     {
         $product_img = $this->programsModel->find($id);  
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {
            $data = $this->request->getVar();
            
              $data['url'] = url_title($this->request->getVar('program_name'));
               $data['updated_at'] = $date;
                 //print_r($data);exit;
                  if($this->programsModel->update($id,$data) == true)
                     {
                         session()->setTempdata('success','Program Updated',2);
                        return redirect()->to(base_url()."/dashboard/viewPrograms");
                     }
             
        }
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall();          
         $data['edit_data']=$this->programsModel->find($id);

         echo view('admin/editPrograms',$data);
     }
     public function deletePrograms($id=null)
     {
         if($this->programsModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewPrograms");
         }
     }


     public function viewProgram()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['programs'] = $this->programModel->orderBy("id", "desc")->findall();   
        
 
         return view('admin/viewProgram',$data);
     }
     
     public function addProgram()
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
        
         if($this->request->getMethod() == 'post')
         {
           
            $data = $this->request->getVar();
            
            $data['url'] = url_title($this->request->getVar('program_name'));
            
            $data['created_at'] = $date;
            if($this->programModel->insert($data))
            {
                session()->setTempdata('success','Program added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewProgram");
            }
                       
         }
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall(); 
 
         return view('admin/addProgram',$data);
     }
 
     public function editProgram($id=null)
     {
         $product_img = $this->programModel->find($id);  
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {
            $data = $this->request->getVar();
            
              $data['url'] = url_title($this->request->getVar('program_name'));
               $data['updated_at'] = $date;
                 //print_r($data);exit;
                  if($this->programModel->update($id,$data) == true)
                     {
                         session()->setTempdata('success','Program Updated',2);
                        return redirect()->to(base_url()."/dashboard/viewProgram");
                     }
             
        }
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall();          
         $data['edit_data']=$this->programModel->find($id);
			
		
         echo view('admin/editProgram',$data);
     }
     public function deleteProgram($id=null)
     {
         if($this->programModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewProgram");
         }
     }


     //speaker cat


     public function viewSpeakerCat($id)
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['speaker_cat'] = $this->speakerCategoryModel->orderBy("id", "desc")->findall();   
        $data['speaker_cat_id'] = $id;
 
         return view('admin/viewSpeakerCat',$data);
     }
     
     public function addSpeakerCat($id)
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
        
         if($this->request->getMethod() == 'post')
         {
           
            $data = $this->request->getVar();
            
            $data['url'] = url_title($this->request->getVar('speaker_cat_name'));
            
            $data['created_at'] = $date;
            if($this->speakerCategoryModel->insert($data))
            {
                session()->setTempdata('success','SpeakerCat added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewSpeakerCat/".$id);
            }
                       
         }
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall(); 
 
         return view('admin/addSpeakerCat',$data);
     }
 
     public function editSpeakerCat($id=null)
     {
         $product_img = $this->speakerCategoryModel->find($id);  
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {
            $data = $this->request->getVar();
            
              $data['url'] = url_title($this->request->getVar('speaker_cat_name'));
               $data['updated_at'] = $date;
                 //print_r($data);exit;
                  if($this->speakerCategoryModel->update($id,$data) == true)
                     {
                         session()->setTempdata('success','SpeakerCat Updated',2);
                        return redirect()->to(base_url()."/dashboard/viewSpeakerCat");
                     }
             
        }
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall();          
         $data['edit_data']=$this->speakerCategoryModel->find($id);

         echo view('admin/editSpeakerCat',$data);
     }
     public function deletespeakerCat($id=null,$pid=null)
     {
         if($this->speakerCategoryModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewSpeakerCat/".$pid);
         }
     }
     public function speakerCatStatus($vid,$status,$pid)
     {
          $sdata['status'] = $status;
          $db=db_connect();
          $builder = $db->table('pd_tbl_speaker_category_dtl');
          $builder->set('status', $status);
         $builder->where('id', $pid);       
        
         if($builder->update())
         {
           //echo $db->getLastQuery();exit;
            
             session()->setTempdata('success','Status Updated',2);
             return redirect()->to(base_url()."/dashboard/viewSpeakerCat/".$vid);
         }
     }

     // program Speakers Data

     public function viewSpeakerData($id,$sid)
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['speaker_data'] = $this->programSpeakersDataModel->where('program_id',$id)->where('speaker_cat_id',$sid)->orderBy("id", "desc")->findall();   
         $data['program_id'] = $id;
         $data['speaker_cat_id'] = $sid;
		 $data['programsarray'] = $this->programModel->orderBy("id", "asc")->findall();

         echo view('admin/viewSpeakerData',$data);
         
     }
	 public function changeSpeakerDay() {
		$request = \Config\Services::request();

		// Fetch the posted speaker_id and program_id
		$speaker_id = $request->getPost('speaker_id');
		$program_id = $request->getPost('program_id');

		if (!empty($speaker_id) && !empty($program_id)) {
			$this->programSpeakersDataModel = new \App\Models\ProgramSpeakersDataModel();
			$updateData = [
				'program_id' => $program_id
			];
			$result = $this->programSpeakersDataModel->update($speaker_id, $updateData);
			if ($result) {
				return json_encode([
					'status' => 'success',
					'message' => 'Speaker day changed successfully!',
				]);
			} else {
				return json_encode([
					'status' => 'error',
					'message' => 'Failed to change the speaker day. Please try again.'
				]);
			}
		} else {
			return json_encode([
				'status' => 'error',
				'message' => 'Speaker ID or Program ID is missing.'
			]);
		}
	}
	
     public function addSpeakerData($pid,$sid)
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {         
            $file = $this->request->getFile('profile_pic');
                
                if($_FILES['profile_pic']['name'] != '')
                {
                    if(isset($_FILES['profile_pic']))
                    {
                    $newName = $file->getRandomName(); 
                    $file->move(FCPATH.'public/programs/',$newName); 
                    }
                }    
            $data = $this->request->getVar();
            
            $data['profile_pic'] = $newName;
            $data['created_at'] = $date;
            //print_r($data);exit;
            if($this->programSpeakersDataModel->insert($data))
            {
                session()->setTempdata('success','Speaker Data added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewSpeakerData/".$pid.'/'.$sid);
            }
         }        
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['program_id'] = $pid;
         $data['speaker_cat_id'] = $sid;
         
          echo view('admin/addSpeakerData',$data);
         
     }
     public function editSpeakerData($id=null)
     {
        $data['coll'] = $this->programSpeakersDataModel->find($id); 
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {            
            $old_pic = $data['coll']['profile_pic'];
            $file = $this->request->getFile('profile_pic');
                if($_FILES['profile_pic']['name'] != '')
                {
                    if(isset($_FILES['profile_pic']))
                    {
                    $newName = $file->getRandomName();
                    $file->move(FCPATH.'public/programs/',$newName);
                    }              
                    
                } 
                else
                {
                    $newName = $old_pic;
                }
              $data = $this->request->getVar();
              $pid = $this->request->getVar('program_id');
               $sid = $this->request->getVar('speaker_id');
              $data['profile_pic'] = $newName;
              $data['updated_at'] = $date;
              //print_r($data);
             /// exit;
              if($this->programSpeakersDataModel->update($id,$data) == true)
              {
                session()->setTempdata('success','Speaker Data Updated',2);
                return redirect()->to(base_url()."/dashboard/viewSpeakerData/".$pid.'/'.$sid);
              } 
        }         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         $data['edit_data']=$this->programSpeakersDataModel->find($id);
        
         echo view('admin/editSpeakerData',$data);
     }
     public function deleteSpekerData($id=null,$pid=null, $pid2=null)
     {
         if($this->programSpeakersDataModel->where('id',$id)->delete())
         {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewSpeakerData/".$pid."/".$pid2);
         }
     }
    
    function updateOrder()
    {
         $pid = $this->request->getVar('pid');   
        $priority_id = $this->request->getVar('order_id');
		$catid = $this->request->getVar('catid');
		
        $order_count = $this->programSpeakersDataModel
		->where('priority_id',$this->request->getVar('order_id'))
		->where('program_id',$pid)
		->where('speaker_cat_id',$catid)
		->find();       
        $id = $this->request->getVar('prog_id');       
        if(count($order_count) == 0)
        {
           $result = $this->programSpeakersDataModel->set('priority_id',$priority_id)->where('id',$id)->update();           
           if($result)
            {
            ?>
                <b style="border: 1px solid black;padding: 10px;border-radius: 5px;color: grey;">Order Updated</b>
            <?php
            }
        }
        else
        {
            echo "<b style='color:red; font-size:22px;'>Duplicate entry of priority</b>";
        }
   }

   // ImportantDates

   function viewImportantDates()
   {
    if(!session()->has('logged_user'))
       {
           return redirect()->to(base_url()."/Admin");
       }
       $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['important_dates'] = $this->importantDatesModel->find(1);     
       $data['reg_dates'] = $this->registrationDate->orderBy("id", "desc")->findall();   

       return view('admin/viewImportantDates',$data);
 
   }
   function editImportantDate($id)
   {
    
        $date=date('Y-m-d H:i:s');
       if($this->request->getMethod() == 'post')
       {
           $data = $this->request->getVar();
           $data['updated_at'] = $date;
           if($this->importantDatesModel->update($id,$data) == true)
            {
                session()->setTempdata('success','Data Updated',2);
               return redirect()->to(base_url()."/dashboard/viewImportantDates");
            }
      }
       
       if(!session()->has('logged_user'))
       {
           return redirect()->to(base_url()."/Admin");
       }
       $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);       
       $data['edit_data']=$this->importantDatesModel->find($id);
       echo view('admin/editImportantDates',$data);
   
   }
   //Coupons Operations


   public function viewCoupons()
   {
       if(!session()->has('logged_user'))
       {
           return redirect()->to(base_url()."/Admin");
       }
       $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

       $data['coupons'] = $this->couponsModel->orderBy("id", "desc")->findall();   
      

       return view('admin/viewCoupons',$data);
   }
   
   public function addCoupon()
   {
       $data = [];
       $data['validation'] = null; 
       $date=date('Y-m-d H:i:s');
       if($this->request->getMethod() == 'post')
       {
           $data = $this->request->getVar();            
           if($this->couponsModel->insert($data))
           {
               session()->setTempdata('success','Coupon added successfully',3);
               return redirect()->to(base_url()."/dashboard/viewCoupons");
           }  
       }
       if(!session()->has('logged_user'))
       {
           return redirect()->to(base_url()."/Admin");
       }
       $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
   
        

       return view('admin/addCoupon',$data);
   }

   public function editCoupon($id=null)
   {
       $product_img = $this->couponsModel->find($id);  
       $date=date('Y-m-d H:i:s');
       if($this->request->getMethod() == 'post')
       {
           $data = $this->request->getVar();
           if($this->couponsModel->update($id,$data) == true)
            {
                session()->setTempdata('success','Leader Updated',2);
               return redirect()->to(base_url()."/dashboard/viewCoupons");
            }
      }
       
       if(!session()->has('logged_user'))
       {
           return redirect()->to(base_url()."/Admin");
       }
       $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);       
       $data['edit_data']=$this->couponsModel->find($id);
       echo view('admin/editCoupon',$data);
   }
   public function deleteCoupon($id=null)
   {
       if($this->couponsModel->where('id',$id)->delete())
       {
           session()->setTempdata('success',' Selected Row Deleted Successfully',2);
           return redirect()->to(base_url()."/dashboard/viewCoupons");
       }
   }
      //all cms content
    public function viewContents()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['content'] = $this->contentModel->findAll();
       //all contents
        return view('admin/viewContent',$data);
    }
    public function viewContent($page)
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['content'] = $this->contentModel->where('page_name',$page)->find();
       //all contents
        return view('admin/viewContent',$data);
    }

    public function editContent($cid)
    {
        $old_icon_data = $this->contentModel->find($cid); 
        $pname=$this->request->getVar('pname');
        
            if($this->request->getMethod() == 'post')
            {               
                $date=date('Y-m-d H:i:s');
                
                $data = $this->request->getVar();
                if($this->request->getVar('page_name') != 'About-Us')
                {
                    if(isset($_FILES['icon']))
                    {
                        $file = $this->request->getFile('icon');
                        $old_icon = $old_icon_data['icon'];
                        if($_FILES['icon']['name'] != '')
                        {
                        //echo 'test'.$_FILES['icon']['name'];exit;
                        
                            // if($_FILES['icon']['name'] != '')
                            // {                            
                            $newName = $file->getRandomName();
                            $file->move(FCPATH.'public/content/',$newName);
                            //}                                            
                        } 
                        else
                        {
                        
                            $newName = $old_icon;
                        }
                        $data['icon'] = $newName;
                    }
                }
                else
                {
                    $data['icon'] = $this->request->getVar('icon');
                }
                    $data['updated_at'] = $date;
               //print_r($data);exit;
                 if($this->contentModel->update($cid,$data) == true)
                    {
                        session()->setTempdata('success','data Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewContent/".$pname);
                    }

       }


       //$cid means content id
       if(!session()->has('logged_user'))
       {
           return redirect()->to(base_url()."/Admin");
       }
       $uniid = session()->get('logged_user');
      $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
      $data['content'] = $this->contentModel->find($cid);

       //all contents
        return view('admin/editContent',$data);
    }


    // More about conferences


    public function viewConferences()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['conferences'] = $this->conferencesModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewConferences',$data);
    }
    
    public function addConferences()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
			if($this->conferencesModel->insert($data))
            {
                session()->setTempdata('success','Conference added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewConferences");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addConferences',$data);
    }

    public function editConferences($id=null)
    {
        $client_img = $this->conferencesModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
            
                 if($this->conferencesModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Conference Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewConferences");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->conferencesModel->find($id);
        echo view('admin/editConferences',$data);
    }
    public function deleteConferences($id=null)
    {
        if($this->conferencesModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewConferences");
        }
    }
    public function deleteall_clients()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->conferencesModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/view");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewConferences");
            }

        }
        
    } 

    
    public function viewConferenceSpeakers($id)
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['conference_speaker'] = $this->conferenceSpeakersModel->where('conference_id',$id)->orderBy("id", "desc")->findall();   
       

        return view('admin/viewConferenceSpeakers',$data);
    }
    
    public function addConferenceSpeakers()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $conference_id =$this->request->getVar('conference_id');
            $file = $this->request->getFile('image');
               
               if($_FILES['image']['name'] != '')
               {
                   if(isset($_FILES['image']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/speakers/',$newName); 
                   }
               }   
            $data['image'] = $newName;
            $data['created_at'] = $date;
            $data['url'] = url_title($this->request->getVar('name').rand());
			if($this->conferenceSpeakersModel->insert($data))
            {
                session()->setTempdata('success','Conference Speaker added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewConferenceSpeakers/".$conference_id);
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addConferenceSpeakers',$data);
    }

    public function editConferenceSpeakers($id=null)
    {
        $client_img = $this->conferenceSpeakersModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
            $data = $this->request->getVar();
            $conference_id = $client_img['conference_id'];
            $old_pic = $client_img['image'];
          $file = $this->request->getFile('image');
              if($_FILES['image']['name'] != '')
              {
                  if(isset($_FILES['image']))
                  {
                  $newName = $file->getRandomName();
                  $file->move(FCPATH.'public/speakers/',$newName);
                  }              
                  
              } 
              else
              {
                  $newName = $old_pic;
              }
            $data['updated_at'] = $date;
            $data['image'] = $newName;
            $data['url'] = url_title($this->request->getVar('name').'-'.rand());
                 if($this->conferenceSpeakersModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Conference Speaker Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewConferenceSpeakers/".$conference_id);
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->conferenceSpeakersModel->find($id);
        echo view('admin/editConferenceSpeakers',$data);
    }
    public function deleteConferenceSpeakers($id=null)
    {
        if($this->conferenceSpeakersModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewConferenceSpeakers");
        }
    }
    public function deleteall_clie()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->conferenceSpeakersModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/view");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewConferences");
            }

        }
        
    } 

    // Registeration Type

    public function viewRegistrationType()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['registration_type'] = $this->registrationTypeModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewRegistrationType',$data);
    }
    
    public function addRegistrationType()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
			if($this->registrationTypeModel->insert($data))
            {
                session()->setTempdata('success','Registration Type added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewRegistrationType");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addRegistrationType',$data);
    }

    public function editRegistrationType($id=null)
    {
        $client_img = $this->registrationTypeModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
            
                 if($this->registrationTypeModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Registeration Type Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewRegistrationType");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->registrationTypeModel->find($id);
        echo view('admin/editRegistrationType',$data);
    }
    public function deleteRegistrationType($id=null)
    {
        if($this->registrationTypeModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewRegistrationType");
        }
    }

    //Addons

    public function viewAddons()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['addons'] = $this->addOnsModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewAddons',$data);
    }
    
    public function addAddons()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
			if($this->addOnsModel->insert($data))
            {
                session()->setTempdata('success','Addon added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewAddons");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addAddons',$data);
    }

    public function editAddons($id=null)
    {
        $client_img = $this->addOnsModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
           // print_r($data);exit;
                 if($this->addOnsModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Addon Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewAddons");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->addOnsModel->find($id);
        echo view('admin/editAddons',$data);
    }
    public function deleteAddons($id=null)
    {
        if($this->addOnsModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewAddons");
        }
    }

    // Registation label dates

    public function viewRegisrationDates()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['reg_dates'] = $this->registrationDate->orderBy("id", "desc")->findall();   
       

        return view('admin/viewRegisrationDates',$data);
    }
    
    public function addRegisrationDates()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
			if($this->registrationDate->insert($data))
            {
                session()->setTempdata('success','Registeration Details added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewRegisrationDates");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addRegisrationDates',$data);
    }

    public function editRegisrationDates($id=null)
    {
        $client_img = $this->registrationDate->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
           // print_r($data);exit;
                 if($this->registrationDate->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Registeration Details Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewRegisrationDates");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->registrationDate->find($id);
        echo view('admin/editRegisrationDates',$data);
    }
    public function deleteRegisrationDates($id=null)
    {
        if($this->registrationDate->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewRegisrationDates");
        }
    }

    //Guidelines

    public function viewRegGuidelines()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['conferences'] = $this->regGuidelinesModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewRegGuidelines',$data);
    }
    
    public function addRegGuidelines()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
			if($this->regGuidelinesModel->insert($data))
            {
                session()->setTempdata('success','Conference added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewRegGuidelines");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addRegGuidelines',$data);
    }

    public function editRegGuidelines($id=null)
    {
        $client_img = $this->regGuidelinesModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
            
                 if($this->regGuidelinesModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Conference Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewRegGuidelines");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->regGuidelinesModel->find($id);
        echo view('admin/editRegGuidelines',$data);
    }
    public function deleteRegGuidelines($id=null)
    {
        if($this->regGuidelinesModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewRegGuidelines");
        }
    }


    // conferences

    public function viewConference()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['conferences'] = $this->conferenceModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewConference',$data);
    }
    
    public function addConference()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
            $data['url'] = url_title($this->request->getVar('title'));

			if($this->conferenceModel->insert($data))
            {
                session()->setTempdata('success','Conference added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewConference");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addConference',$data);
    }

    public function editConference($id=null)
    {
        $client_img = $this->conferenceModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
             $data['url'] = url_title($this->request->getVar('title'));
            
                 if($this->conferenceModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Conference Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewConference");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->conferenceModel->find($id);
        echo view('admin/editConference',$data);
    }
    public function deleteConference($id=null)
    {
        if($this->conferenceModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewConference");
        }
    }

    //Renewed Speakers


    public function viewRenewedSpeakers()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['renewed_speaker'] = $this->renewedSpeakersModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewRenewedSpeakers',$data);
    }
    
    public function addRenewedSpeakers()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $file = $this->request->getFile('image');
               
               if($_FILES['image']['name'] != '')
               {
                   if(isset($_FILES['image']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/speaker/',$newName); 
                   }
               }   
            $data['image'] = $newName;
            $data['created_at'] = $date;
			if($this->renewedSpeakersModel->insert($data))
            {
                session()->setTempdata('success','Conference added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewRenewedSpeakers");
            }                        
               
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addRenewedSpeakers',$data);
    }

    public function editRenewedSpeakers($id=null)
    {
        $renewed_img = $this->renewedSpeakersModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
             $data = $this->request->getVar();
             $old_pic = $renewed_img['image'];
           $file = $this->request->getFile('image');
               if($_FILES['image']['name'] != '')
               {
                   if(isset($_FILES['image']))
                   {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/speakers/',$newName);
                   }              
                   
               } 
               else
               {
                   $newName = $old_pic;
               }
             $data['updated_at'] = $date;
             $data['image'] = $newName;
            
                 if($this->renewedSpeakersModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Conference Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewRenewedSpeakers");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->renewedSpeakersModel->find($id);
        echo view('admin/editRenewedSpeakers',$data);
    }
    public function deleteRenewedSpeakers($id=null)
    {
        if($this->renewedSpeakersModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewRenewedSpeakers");
        }
    }
    public function deleteall_renewed()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->renewedSpeakersModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/view");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewRenewedSpeakers");
            }

        }
        
    }
    //pastconference videos

    
    public function viewConferenceVideos()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['conf_videos'] = $this->conferenceVideosModel->orderBy("id", "desc")->findall();   
       
        echo view('admin/viewConferenceVideos',$data);        
    }
    public function addConferenceVideos()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {         
             
           $data = $this->request->getVar();
         
           $data['created_at'] = $date;
           //print_r($data);exit;
           if($this->conferenceVideosModel->insert($data))
           {
               session()->setTempdata('success','Video added successfully',3);
               return redirect()->to(base_url()."/dashboard/viewConferenceVideos");
           }
        }        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['category'] = $this->categoryModel->findall(); 
        $data['conferences'] = $this->conferenceModel->find();
        
        
         echo view('admin/addConferenceVideos',$data);
        
    }
    public function editConferenceVideos($id=null)
    {
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
         
             $data = $this->request->getVar();
             $data['updated_at'] = $date;
             //print_r($data);exit;
             if($this->conferenceVideosModel->update($id,$data) == true)
             {
               session()->setTempdata('success','Image Updated',2);
               return redirect()->to(base_url()."/dashboard/viewConferenceVideos");
             } 
       }         
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->conferenceVideosModel->find($id);
        $data['category'] = $this->categoryModel->findall(); 
        $data['conferences'] = $this->conferenceModel->find();


        echo view('admin/editConferenceVideos',$data);
    }
    public function deleteConferenceVideos($id=null)
    {
        if($this->conferenceVideosModel->where('id',$id)->delete())
        {
           session()->setTempdata('success',' Selected Row Deleted Successfully',2);
           return redirect()->to(base_url()."/dashboard/viewConferenceVideos");
        }
    }

    public function viewConferenceUsers($id=null)
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['contact'] = $this->pastCoferenceUsersModel->orderBy('id','desc')->findAll();

       return view('admin/viewConferenceUsers',$data);
        
    }
    public function deleteConferenceUsers($id=null)
    {
        if($this->pastCoferenceUsersModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/viewConferenceUsers");
        }
    }


    // gallery


    public function viewConferenceGallery()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['gallery'] = $this->conferenceGalleryModel->orderBy("id", "desc")->findall();   
       
        echo view('admin/viewConferenceGallery',$data);
        
    }
    public function addConferenceGallery()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {         
           $file = $this->request->getFile('image_path');
               
               if($_FILES['image_path']['name'] != '')
               {
                   if(isset($_FILES['image_path']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/gallery/',$newName); 
                   }
               }    
           $data = $this->request->getVar();
           $data['image_path'] = $newName;
           $data['created_at'] = $date;
           //print_r($data);exit;
           if($this->conferenceGalleryModel->insert($data))
           {
               session()->setTempdata('success','Image added successfully',3);
               return redirect()->to(base_url()."/dashboard/viewConferenceGallery");
           }
        }        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['category'] = $this->categoryModel->findall(); 
        
        
         echo view('admin/addConferenceGallery',$data);
        
    }
    public function editConferenceGallery($id=null)
    {
       $data['coll'] = $this->conferenceGalleryModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           $old_pic = $data['coll']['image_path'];
           $file = $this->request->getFile('image_path');
               if($_FILES['image_path']['name'] != '')
               {
                   if(isset($_FILES['image_path']))
                   {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/gallery/',$newName);
                   }              
                   
               } 
               else
               {
                   $newName = $old_pic;
               }
             $data = $this->request->getVar();
             $data['image_path'] = $newName;
             $data['updated_at'] = $date;
             //print_r($data);exit;
             if($this->conferenceGalleryModel->update($id,$data) == true)
             {
               session()->setTempdata('success','Image Updated',2);
               return redirect()->to(base_url()."/dashboard/viewConferenceGallery");
             } 
       }         
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->conferenceGalleryModel->find($id);
        $data['category'] = $this->categoryModel->findall(); 
        echo view('admin/editConferenceGallery',$data);
    }
    public function deleteConferenceGallery($id=null)
    {
        if($this->conferenceGalleryModel->where('id',$id)->delete())
        {
           session()->setTempdata('success',' Selected Row Deleted Successfully',2);
           return redirect()->to(base_url()."/dashboard/viewConferenceGallery");
        }
    }


    // Past conference proceedings


    public function viewPastProceedings()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['proceedings'] = $this->pastProceedingsModel->orderBy("id", "desc")->findall();   
       
        echo view('admin/viewPastProceedings',$data);
        
    }
    public function addPastProceedings()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {         
           $file = $this->request->getFile('pdf');
               
               if($_FILES['pdf']['name'] != '')
               {
                   if(isset($_FILES['pdf']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/gallery/',$newName); 
                   }
               }    
           $data = $this->request->getVar();
           $data['pdf'] = $newName;
           $data['created_at'] = $date;
           //print_r($data);exit;
           if($this->pastProceedingsModel->insert($data))
           {
               session()->setTempdata('success','Proceeding added successfully',3);
               return redirect()->to(base_url()."/dashboard/viewPastProceedings");
           }
        }        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['category'] = $this->categoryModel->findall(); 
        
        
         echo view('admin/addPastProceedings',$data);
        
    }
    public function editPastProceedings($id=null)
    {
       $data['coll'] = $this->pastProceedingsModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           $old_pic = $data['coll']['pdf'];
           $file = $this->request->getFile('pdf');
               if($_FILES['pdf']['name'] != '')
               {
                   if(isset($_FILES['pdf']))
                   {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/gallery/',$newName);
                   }              
                   
               } 
               else
               {
                   $newName = $old_pic;
               }
             $data = $this->request->getVar();
             $data['pdf'] = $newName;
             $data['updated_at'] = $date;
             //print_r($data);exit;
             if($this->pastProceedingsModel->update($id,$data) == true)
             {
               session()->setTempdata('success','Proceeding Updated',2);
               return redirect()->to(base_url()."/dashboard/viewPastProceedings");
             } 
       }         
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->pastProceedingsModel->find($id);
        $data['category'] = $this->categoryModel->findall(); 
        echo view('admin/editPastProceedings',$data);
    }
    public function deletePastProceedings($id=null)
    {
        if($this->pastProceedingsModel->where('id',$id)->delete())
        {
           session()->setTempdata('success',' Selected Row Deleted Successfully',2);
           return redirect()->to(base_url()."/dashboard/viewPastProceedings");
        }
    }

// Brochures


public function viewBrochures($id)
{
    if(!session()->has('logged_user'))
    {
        return redirect()->to(base_url()."/Admin");
    }
    $uniid = session()->get('logged_user');
    $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
    $data['brou_data'] = $this->brochuresModel->find($id);   
   
    echo view('admin/viewBrochures',$data);
    
}
public function addBrochure()
{
    $data = [];
    $data['validation'] = null; 
    $date=date('Y-m-d H:i:s');
    if($this->request->getMethod() == 'post')
    {         
       $file = $this->request->getFile('brochure_pdf');
           
           if($_FILES['brochure_pdf']['name'] != '')
           {
               if(isset($_FILES['brochure_pdf']))
               {
               $newName = $file->getRandomName(); 
               $file->move(FCPATH.'public/brochure/',$newName); 
               }
           }    
       $data = $this->request->getVar();
       $data['brochure_pdf'] = $newName;
       $data['created_at'] = $date;
       //print_r($data);exit;
       if($this->brochuresModel->insert($data))
       {
           session()->setTempdata('success','Brochure added successfully',3);
           return redirect()->to(base_url()."/dashboard/viewBrochures");
       }
    }        
    if(!session()->has('logged_user'))
    {
        return redirect()->to(base_url()."/Admin");
    }
    $uniid = session()->get('logged_user');
    $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
    $data['category'] = $this->categoryModel->findall(); 
    
    
     echo view('admin/addBrochure',$data);
    
}
public function editBrochure($id=null)
{
   $data['coll'] = $this->brochuresModel->find($id); 
    $date=date('Y-m-d H:i:s');
    if($this->request->getMethod() == 'post')
    {            
       $old_pic = $data['coll']['brochure_pdf'];
       $file = $this->request->getFile('brochure_pdf');
           if($_FILES['brochure_pdf']['name'] != '')
           {
               if(isset($_FILES['brochure_pdf']))
               {
               $newName = $file->getRandomName();
               $file->move(FCPATH.'public/brochure/',$newName);
               }              
               
           } 
           else
           {
               $newName = $old_pic;
           }
         $data = $this->request->getVar();
         $data['brochure_pdf'] = $newName;
         $data['updated_at'] = $date;
         //print_r($data);exit;
         if($this->brochuresModel->update($id,$data) == true)
         {
           session()->setTempdata('success','Brochure Updated',2);
           return redirect()->to(base_url()."/dashboard/viewBrochures/".$id);
         } 
   }         
    if(!session()->has('logged_user'))
    {
        return redirect()->to(base_url()."/Admin");
    }
    $uniid = session()->get('logged_user');
    $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
    
    $data['edit_data']=$this->brochuresModel->find($id);
    $data['category'] = $this->categoryModel->findall(); 
    echo view('admin/editBrochure',$data);
}
public function deleteBrochure($id=null)
{
    if($this->brochuresModel->where('id',$id)->delete())
    {
       session()->setTempdata('success',' Selected Row Deleted Successfully',2);
       return redirect()->to(base_url()."/dashboard/viewBrochures");
    }
}



























    //news letter


    public function viewNewsletters()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
       $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
       $data['news_letter'] = $this->newsModel->findAll();
        return view('admin/viewNewsLetter',$data);
        
    }
    public function deleteNewsLetter($id=null)
    {
        if($this->newsModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' deleted successfully',2);
            return redirect()->to(base_url()."/dashboard/viewNewsletters");
        }
    }

    public function deleteall_news_enq()
    {
        if($this->request->getMethod() == 'post')
        {
            if(!empty($this->request->getVar('checked_id')))
            {
                $check = $this->request->getVar('checked_id');
                $chk_id=[];
                foreach($check as $chk)
                {
                    array_push($chk_id,$chk);                
                }
                //print_r($chk_id);exit;
                if($this->newsModel->wherein('id',$chk_id)->delete())
                    {
                        session()->setTempdata('success',' Selected Rows Deleted Successfully',2);
                        
                    }
                return redirect()->to(base_url()."/dashboard/viewNewsletters");
            }
            else
            {
                session()->setTempdata('error',' Select Atlease One Client',2);
                return redirect()->to(base_url()."/dashboard/viewContacts");
            }

        }
    }




   



    //Venue Operations


    public function viewVenue()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['venue'] = $this->venueModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewVenue',$data);
    }
    
    public function addVenue()
    {
        $data = [];
        $date=date('Y-m-d H:i:s');       
        if($this->request->getMethod() == 'post')
        {
            $data =$this->request->getVar();
            $data['created_at'] = $date;
            if($this->venueModel->insert($data))
            {
                session()->setTempdata('success','Venue added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewVenue");
            }                      
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addVenue',$data);
    }

    public function editVenue($id=null)
    {
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
          $data =$this->request->getVar();         
          $data['updated_at'] = $date;
          if($this->venueModel->update($id,$data) == true)
          {
            session()->setTempdata('success','Venue Updated',2);
            return redirect()->to(base_url()."/dashboard/viewVenue");
          }
        }        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->venueModel->find($id);

        echo view('admin/editVenue',$data);
    }
    public function deleteVenue($id=null)
    {
        if($this->venueModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewVenue");
        }
    }
    public function venueStatusUpdate($status,$vid)
     {
          $sdata['status'] = $status;
          $db=db_connect();
          $builder = $db->table('pd_tbl_venue_dtl');
          $builder->set('status', $status);
         $builder->where('id', $vid);       
        
         if($builder->update())
         {
            
             session()->setTempdata('success','Status Updated',2);
             return redirect()->to(base_url()."/dashboard/viewVenue");
         }
     }

    // gallery



    public function viewHotelGallery($id)
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['hotel_gallery'] = $this->hotelGalleryModel->where('venue_id',$id)->orderBy("id", "desc")->findall();   
        $data['venue_id'] = $id;
        echo view('admin/viewHotelGallery',$data);
        
    }
    public function addHotelGallery($pid)
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {         
           $file = $this->request->getFile('hotel_image');
               
               if($_FILES['hotel_image']['name'] != '')
               {
                   if(isset($_FILES['hotel_image']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/venue/',$newName); 
                   }
               }    
           $data = $this->request->getVar();
           
           $data['hotel_image'] = $newName;
           $data['created_at'] = $date;
           //print_r($data);exit;
           if($this->hotelGalleryModel->insert($data))
           {
               session()->setTempdata('success','Image added successfully',3);
               return redirect()->to(base_url()."/dashboard/viewHotelGallery/".$pid);
           }
        }        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['venue_id'] = $pid;
        
         echo view('admin/addHotelGallery',$data);
        
    }
    public function editHotelGallery($id=null)
    {
       $data['coll'] = $this->hotelGalleryModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           $old_pic = $data['coll']['hotel_image'];
           $file = $this->request->getFile('hotel_image');
               if($_FILES['hotel_image']['name'] != '')
               {
                   if(isset($_FILES['hotel_image']))
                   {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/venue/',$newName);
                   }              
                   
               } 
               else
               {
                   $newName = $old_pic;
               }
             $data = $this->request->getVar();
             $pid = $this->request->getVar('venue_id');
             $data['hotel_image'] = $newName;
             $data['updated_at'] = $date;
             //print_r($data);exit;
             if($this->hotelGalleryModel->update($id,$data) == true)
             {
               session()->setTempdata('success','Category Updated',2);
               return redirect()->to(base_url()."/dashboard/viewHotelGallery/".$pid);
             } 
       }         
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->hotelGalleryModel->find($id);
       
        echo view('admin/editHotelGallery',$data);
    }
    public function deleteHotelGallery($id=null,$pid=null)
    {
        if($this->hotelGalleryModel->where('id',$id)->delete())
        {
           session()->setTempdata('success',' Selected Row Deleted Successfully',2);
           return redirect()->to(base_url()."/dashboard/viewHotelGallery/".$pid);
        }
    }






    public function viewVenueGallery($id)
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['design_gallery'] = $this->venueGalleryModel->where('venue_id',$id)->orderBy("id", "desc")->findall();   
        $data['venue_id'] = $id;
        echo view('admin/viewVenueGallery',$data);
        
    }
    public function addVenueGallery($pid)
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {         
           $file = $this->request->getFile('venue_image');
               
               if($_FILES['venue_image']['name'] != '')
               {
                   if(isset($_FILES['venue_image']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/venue/',$newName); 
                   }
               }    
           $data = $this->request->getVar();
           
           $data['venue_image'] = $newName;
           $data['created_at'] = $date;
           //print_r($data);exit;
           if($this->venueGalleryModel->insert($data))
           {
               session()->setTempdata('success','Image added successfully',3);
               return redirect()->to(base_url()."/dashboard/viewVenueGallery/".$pid);
           }
        }        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['venue_id'] = $pid;
        
         echo view('admin/addVenueGallery',$data);
        
    }
    public function editVenueGallery($id=null)
    {
       $data['coll'] = $this->venueGalleryModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           $old_pic = $data['coll']['venue_image'];
           $file = $this->request->getFile('venue_image');
               if($_FILES['venue_image']['name'] != '')
               {
                   if(isset($_FILES['venue_image']))
                   {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/venue/',$newName);
                   }              
                   
               } 
               else
               {
                   $newName = $old_pic;
               }
             $data = $this->request->getVar();
             $pid = $this->request->getVar('venue_id');
             $data['venue_image'] = $newName;
             $data['updated_at'] = $date;
             //print_r($data);exit;
             if($this->venueGalleryModel->update($id,$data) == true)
             {
               session()->setTempdata('success','Category Updated',2);
               return redirect()->to(base_url()."/dashboard/viewVenueGallery/".$pid);
             } 
       }         
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->venueGalleryModel->find($id);
       
        echo view('admin/editVenueGallery',$data);
    }
    public function deleteVenueGallery($id=null,$pid=null)
    {
        if($this->venueGalleryModel->where('id',$id)->delete())
        {
           session()->setTempdata('success',' Selected Row Deleted Successfully',2);
           return redirect()->to(base_url()."/dashboard/viewVenueGallery/".$pid);
        }
    }





    

    

   


   
    // Careers Operations

    public function viewCareers()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['job_list'] = $this->careersModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewCareers',$data);
    }
    public function addCareer()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
                $file = $this->request->getFile('logo');
                
                if($_FILES['logo']['name'] != '')
                {
                    $newName = $file->getRandomName();                   
                    $file->move(FCPATH.'public/careers/',$newName);
                }
                  
                    $data =[
                        'logo' => $newName,
                        'title' => $this->request->getVar('title'),
                        'role' => $this->request->getVar('role'),
                        'salary' => $this->request->getVar('salary'),
                        'skills' => $this->request->getVar('skills'),
                        'job_description'=> $this->request->getVar('job_description'),
                        'created_date' => $date,
                        
                    ];
                    
                    
                       
                            if($this->careersModel->insert($data))
                            {
                                session()->setTempdata('success','Job added successfully',3);
                                return redirect()->to(base_url()."/dashboard/viewCareers");
                            }
            
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addCareer',$data);
    }
    public function editCareer($id=null)
    {
        $career_img = $this->careersModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $old_img = $career_img['logo'];
            $file = $this->request->getFile('logo');

             //if($file->isValid() && !$file->hasMoved())

             if($_FILES['logo']['name'] != '')
             {
                if(isset($_FILES['logo']))
                {
                    $newName = $file->getRandomName();
                    $file->move(FCPATH.'public/careers/',$newName);
                
                    // if(file_exists('public/careers/'.$old_img))
                    // {
                    //     if($old_img != '')     
                    //     {                   
                    //         unlink('public/careers/'.$old_img);
                    //         $file->move(FCPATH.'public/careers/',$newName);
                    //     }
                    //     else
                    //     {
                    //         $file->move(FCPATH.'public/careers/',$newName);
                    //     }
                   
                    // }
                }
            }
             else
             {
                $newName = $old_img;
             }
             $data = [
                    'title' => $this->request->getVar('title'),
                    'logo' => $newName,
                    'role' => $this->request->getVar('role'),
                    'salary' => $this->request->getVar('salary'),
                    'skills' => $this->request->getVar('skills'),
                    'job_description'=> $this->request->getVar('job_description'),
                    'updated_date' => $date,
                ];
                //print_r($data);exit;
                 if($this->careersModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Client Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewCareers");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->careersModel->find($id);
        echo view('admin/editCareer',$data);
    }
    public function deleteCareer($id=null)
    {
        if($this->careersModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewCareers");
        }
    }

    // Settings

    public function viewSettings()
    {
        
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            
                $data = $this->request->getVar();
                $data['updated_date'] = $date;
                $data['footer_content'] = addslashes($this->request->getVar('footer_content'));
                $id = 1;
				$file = $this->request->getFile('program_download');
				if ($file != NULL) {
					if($_FILES['program_download']['name'] != '')
                    {
                        if(isset($_FILES['program_download']))
                        {
                            $newName = $_FILES['program_download']['name'];
                            $file->move(FCPATH.'public/testmonials/',$newName);
                        }
						 $data['program_download'] = $newName;
                    }
				}
                   
                //print_r($data);die;
                 if($this->settingsModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Settings Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewSettings");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['edit_data']=$this->settingsModel->find(1);

        echo view('admin/viewSettings',$data);
    }
	
	public function deleteProgramFile()
	{
		$id = 1;
		// Check if the user is logged in
		if (!session()->has('logged_user')) {
			return redirect()->to(base_url()."/Admin");
		}

		// Fetch the record to ensure it exists
		$settingsData = $this->settingsModel->find($id);

		if ($settingsData) {
			$filePath = FCPATH . 'public/testmonials/' . $settingsData['program_download'];

			// Check if the file exists in the directory
			if (file_exists($filePath)) {
				// Attempt to delete the file from the directory
				if (unlink($filePath)) {
					// Update the database to remove the file reference
					$this->settingsModel->update($id, ['program_download' => null]);

					// Set success message in session
					session()->setTempdata('success', 'Program file deleted successfully', 2);
				} else {
					// Set error message if file deletion fails
					session()->setTempdata('error', 'Failed to delete program file', 2);
				}
			} else {
				// Set error message if the file is not found
				session()->setTempdata('error', 'Program file not found', 2);
			}
		} else {
			// Set error message if record does not exist
			session()->setTempdata('error', 'Settings record not found', 2);
		}

		// Redirect back to the settings page
		return redirect()->to(base_url() . "/dashboard/viewSettings");
	}

     //Category operations
     public function viewCategory()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['category'] = $this->categoryModel->orderBy("id", "desc")->findall();   
        
         echo view('admin/viewCategory',$data);
         
     }
     public function addCategory()
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {   
            $data = $this->request->getVar();
            $file = $this->request->getFile('image');
			
			if($file != NULL){
				if($_FILES['image']['name'] != '')
				{
					if(isset($_FILES['image']))
					{
					$newName = $file->getRandomName(); 
					$file->move(FCPATH.'public/category/',$newName); 
					}
				}
			}
            $data['created_date'] = $date;
            //print_r($data);exit;
            if($this->categoryModel->insert($data))
            {
                session()->setTempdata('success','Category added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewCategory");
            }
         }
            
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         
          echo view('admin/addCategory',$data);
         
     }
     public function editCategory($id=null)
     {         
        $data['coll'] = $this->categoryModel->find($id); 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           $old_pic = $data['coll']['cat_image'];
           $file = $this->request->getFile('cat_image');
           if($_FILES['cat_image']['name'] != '')
           {
               if(isset($_FILES['cat_image']))
               {
               $newName = $file->getRandomName();
               $file->move(FCPATH.'public/category/',$newName);
               }              
               
           } 
           else
           {
               $newName = $old_pic;
           }
                
           $data = $this->request->getVar();
           $data['cat_image'] = $newName;    
           $data['updated_date'] = $date;
           //print_r($data);exit;
           if($this->categoryModel->update($id,$data) == true)
           {
              session()->setTempdata('success','Category Updated',2);
              return redirect()->to(base_url()."/dashboard/viewCategory");
           }                  
        }         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         $data['edit_data']=$this->categoryModel->find($id);
         echo view('admin/editCategory',$data);
     }
     public function deleteCategory($id=null)
     {
         if($this->categoryModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewCategory");
         }
     }

     //Scientific Committee perations
     
     public function viewCommittee()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['scientific_committee'] = $this->committeeModel->orderBy("id", "desc")->findall();   
        
         echo view('admin/viewCommittee',$data);
         
     }
     public function addCommittee()
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {   
            $data = $this->request->getVar();
            $file = $this->request->getFile('profile_pic');
				if($_FILES['profile_pic']['name'] != '')
                {
                    if(isset($_FILES['profile_pic']))
                    {
                    $newName = $file->getRandomName(); 
                    $file->move(FCPATH.'public/committee/',$newName); 
                    }
                }    
            $data['profile_pic'] = $newName;
            $data['created_at'] = $date;
            $data['url']=url_title($this->request->getVar('name'));
            if($this->committeeModel->insert($data))
            {
                session()->setTempdata('success','Scientific Committee added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewCommittee");
            }
         }        
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data['category'] = $this->categoryModel->findall(); 
         
         
          echo view('admin/addCommittee',$data);
         
     }
     public function editCommittee($id=null)
     {
        $data['coll'] = $this->committeeModel->find($id); 
         $date=date('Y-m-d H:i:s');
         if($this->request->getMethod() == 'post')
         {            
            $old_pic = $data['coll']['profile_pic'];
            $file = $this->request->getFile('profile_pic');
                if($_FILES['profile_pic']['name'] != '')
                {
                    if(isset($_FILES['profile_pic']))
                    {
                    $newName = $file->getRandomName();
                    $file->move(FCPATH.'public/committee/',$newName);
                    }              
                    
                } 
                else
                {
                    $newName = $old_pic;
                }
              $data = $this->request->getVar();
              $data['profile_pic'] = $newName;
              $data['updated_at'] = $date;
              $data['url']=url_title($this->request->getVar('name')).'-'.rand();

             // print_r($data);exit;
              if($this->committeeModel->update($id,$data) == true)
              {
                session()->setTempdata('success','Category Updated',2);
                return redirect()->to(base_url()."/dashboard/viewCommittee");
              } 
        }         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         $data['edit_data']=$this->committeeModel->find($id);
         $data['category'] = $this->categoryModel->findall(); 
         echo view('admin/editCommittee',$data);
     }
     public function deleteCommittee($id=null)
     {
         if($this->committeeModel->where('id',$id)->delete())
         {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewCommittee");
         }
     }
     public function scientificCommitteeStatus($status,$pid)
     {
          $sdata['status'] = $status;
          $db=db_connect();
          $builder = $db->table('pd_tbl_scientific_committee_dtl');
          $builder->set('status', $status);
         $builder->where('id', $pid);       
        
         if($builder->update())
         {
           // echo $db->getLastQuery();exit;
            
             session()->setTempdata('success','Status Updated',2);
             return redirect()->to(base_url()."/dashboard/viewCommittee/");
         }
     }


     //scientific sessions operations
     public function viewSessions()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['scientific_sessions'] = $this->sessionsModel->orderBy("id", "desc")->findall();   
        
         echo view('admin/viewSessions',$data);
         
     }
     public function addSessions()
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
          if($this->request->getMethod() == 'post')
         {   
                  
            $data = $this->request->getVar();
            $data['created_at'] = $date;
            if($this->sessionsModel->insert($data))
            {
                session()->setTempdata('success','Scientific Session added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewSessions");
            }
         }
            
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         
          echo view('admin/addSessions',$data);
         
     }
     public function editSessions($id=null)
     {         
       
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           
           $data = $this->request->getVar();
           $data['updated_at'] = $date;
           //print_r($data);exit;
           if($this->sessionsModel->update($id,$data) == true)
           {
              session()->setTempdata('success','Scientific Session Updated',2);
              return redirect()->to(base_url()."/dashboard/viewSessions");
           }                  
        }         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         $data['edit_data']=$this->sessionsModel->find($id);
         echo view('admin/editSessions',$data);
     }
     public function deleteSessions($id=null)
     {
         if($this->sessionsModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewSessions");
         }
     }


//Countries

     public function viewCountriesList()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['country'] = $this->countriesModel->orderBy("id", "desc")->findall();   
        
         echo view('admin/viewCountriesList',$data);
         
     }
     public function addCountriesList()
     {
         $data = [];
         $data['validation'] = null; 
         $date=date('Y-m-d H:i:s');
          if($this->request->getMethod() == 'post')
         {   
                  
            $data = $this->request->getVar();
            $data['created_at'] = $date;
            if($this->countriesModel->insert($data))
            {
                session()->setTempdata('success','Scientific Session added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewCountriesList");
            }
         }
            
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         
          echo view('admin/addCountriesList',$data);
         
     }
     public function editCountriesList($id=null)
     {         
       
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           
           $data = $this->request->getVar();
           $data['updated_at'] = $date;
           //print_r($data);exit;
           if($this->countriesModel->update($id,$data) == true)
           {
              session()->setTempdata('success','Scientific Session Updated',2);
              return redirect()->to(base_url()."/dashboard/viewCountriesList");
           }                  
        }         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         $data['edit_data']=$this->countriesModel->find($id);
         echo view('admin/editCountriesList',$data);
     }
     public function deleteCountriesList($id=null)
     {
         if($this->countriesModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewCountriesList");
         }
     }


     //SEO

     public function viewSeo()
     {
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
 
         $data['seo_list'] = $this->seoModel->orderBy("id", "desc")->findall();   
        
         echo view('admin/viewSeo',$data);
         
     }
     public function addSeo()
     {
         $data = [];
         $date=date('Y-m-d H:i:s');
          if($this->request->getMethod() == 'post')
         {   
                  
            $data = $this->request->getVar();
            $data['created_at'] = $date;
            if($this->seoModel->insert($data))
            {
                session()->setTempdata('success','Seo added successfully',3);
                return redirect()->to(base_url()."/dashboard/viewSeo");
            }
         }
            
         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         
         
          echo view('admin/addSeo',$data);
         
     }
     public function editSeo($id=null)
     {         
       
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {            
           
           $data = $this->request->getVar();
           $data['updated_at'] = $date;
           //print_r($data);exit;
           if($this->seoModel->update($id,$data) == true)
           {
              session()->setTempdata('success','Data Updated',2);
              return redirect()->to(base_url()."/dashboard/viewSeo");
           }                  
        }         
         if(!session()->has('logged_user'))
         {
             return redirect()->to(base_url()."/Admin");
         }
         $uniid = session()->get('logged_user');
         $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
         $data_tag = $this->seoModel->find($id);
         
         $data['title'] = $data_tag['page_name'];
         $data['edit_data']=$this->seoModel->find($id);
         echo view('admin/editSeo',$data);
     }
     public function deleteSeo($id=null)
     {
         if($this->seoModel->where('id',$id)->delete())
         {
             session()->setTempdata('success',' Selected Row Deleted Successfully',2);
             return redirect()->to(base_url()."/dashboard/viewSeo");
         }
     }



     
     

     

    //Products Operations


    public function viewLeader()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['products'] = $this->productsModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewLeader',$data);
    }
    
    public function addLeader()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
                $file = $this->request->getFile('image');
                if($_FILES['image']['name'] != '')
                {
                    $newName = $file->getRandomName();                   
                    $file->move(FCPATH.'public/products/',$newName);
                }
                    $newName = $file->getRandomName();
                    $data =[
                        'name' => $this->request->getVar('name'),
                        'image' => $newName,
                        'details' => $this->request->getVar('details'),
                        'description'=> $this->request->getVar('description'),
                        'created_at' => $date,
                        
                    ];               
                    //print_r($data);exit;
                    
                       
                            if($this->productsModel->insert($data))
                            {
                                session()->setTempdata('success','Leader added successfully',3);
                                return redirect()->to(base_url()."/dashboard/viewLeader");
                            }
                       
                
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addProduct',$data);
    }

    public function editLeader($id=null)
    {
        $product_img = $this->productsModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $old_product_img = $product_img['image'];
            $file = $this->request->getFile('image');

             //if($file->isValid() && !$file->hasMoved())
             if($_FILES['image']['name'] != '')
             {
                if(isset($_FILES['image']))
                {
                    $newName = $file->getRandomName();
                    $file->move(FCPATH.'public/leaders/',$newName);
                    // if(file_exists('public/products/'.$old_product_img))
                    // {
                        // if($old_product_img != '')     
                        // {    
                        //     unlink('public/leaders/'.$old_product_img);
                        //     $file->move(FCPATH.'public/leaders/',$newName);               
                        // }
                        // else
                        // {
                        //     $file->move(FCPATH.'public/leaders/',$newName);
                        // }                    
                    //}
                }
            }
             else
             {
                $newName = $old_product_img;
             }
             $data = [
                    'name' => $this->request->getVar('name'),
                    'image' => $newName,
                    'details' => $this->request->getVar('details'),
                    'description'=> $this->request->getVar('description'),
                    'updated_at' => $date,
                ];
                //print_r($data);exit;
                 if($this->productsModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Leader Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewLeader");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->productsModel->find($id);
        echo view('admin/editLeader',$data);
    }
    public function deleteLeader($id=null)
    {
        if($this->productsModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewLeader");
        }
    }
    //Inner products

    public function viewInnerProducts()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['inner_products'] = $this->innerProductModel->orderBy("id", "desc")->findall();   
       

        return view('admin/viewInnerProducts',$data);
    }
    public function addInnerProducts()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
                $data = $this->request->getVar();
                $file = $this->request->getFile('image');
                $file1 = $this->request->getFile('server_image');
                $file2 = $this->request->getFile('inner_image');
                $file3 = $this->request->getFile('product_image');
                if($_FILES['image']['name'] != '')
                {
                    if(isset($_FILES['image']))
                    {
                        $newName = $file->getRandomName();      
                        $file->move(FCPATH.'public/products/',$newName);                                               
                    }
                }
                if($_FILES['server_image']['name'] != '')
                {
                    if(isset($_FILES['server_image']))
                    {
                        $newName1 = $file1->getRandomName();      
                        $file1->move(FCPATH.'public/products/',$newName1);                            
                    }
                }               
                if($_FILES['inner_image']['name'] != '')
                {
                    if(isset($_FILES['inner_image']))
                    {
                        $newName2 = $file2->getRandomName();      
                        $file2->move(FCPATH.'public/products/',$newName2);
                    }                    
                }
                if($_FILES['product_image']['name'] != '')
                {
                    if(isset($_FILES['product_image']))
                    {
                        $newName3 = $file3->getRandomName();      
                        $file3->move(FCPATH.'public/products/',$newName3);
                    }                    
                }
               
           
            $data = $this->request->getVar();
            $data['image'] = $newName;
            $data['server_image'] = $newName1;
            $data['inner_image'] = $newName2;
            $data['product_image'] = $newName3;

            $data['created_date'] = $date; 
            $data['url'] = url_title(url_title($this->request->getVar('product_name')));      
                    //print_r($data);exit;
                        
                        if($this->innerProductModel->insert($data))
                        {
                            session()->setTempdata('success','Product added successfully',3);
                            return redirect()->to(base_url()."/dashboard/viewInnerProducts");
                        }                       
                        else
                        {
                            echo $file->getErrorString()." ".$file->getError();
                        }
                
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        return view('admin/addInnerProduct',$data);
    }
    public function editInnerProduct($id=null)
    {
        $product_img = $this->innerProductModel->find($id);  
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $old_product_img = $product_img['image'];
            $old_server_img = $product_img['server_image'];
            $old_inner_img = $product_img['inner_image'];
            $old_products_img = $product_img['product_image'];
            $file = $this->request->getFile('image');
            $file1 = $this->request->getFile('server_image');
            $file2 = $this->request->getFile('inner_image');
            $file3 = $this->request->getFile('product_image');

             //if($file->isValid() && !$file->hasMoved())
             if($_FILES['image']['name'] != '')
             {
                if(isset($_FILES['image']))
                {
                    $newName = $file->getRandomName();      
                    $file->move(FCPATH.'public/products/',$newName);
                        // if($old_product_img != '')     
                        // {    
                        //     unlink('public/products/'.$old_product_img);
                        //     $file->move(FCPATH.'public/products/',$newName);               
                        // }
                        // else
                        // {
                        //     $file->move(FCPATH.'public/products/',$newName);
                        // }                    
                }
            }
             else
             {
                $newName = $old_product_img;
             }
            // echo $newName;exit;
             if($_FILES['server_image']['name'] != '')
             {
                if(isset($_FILES['server_image']))
                {
                    $newName1 = $file1->getRandomName();    
                    $file1->move(FCPATH.'public/products/',$newName1);  
                        // if($old_server_img != '')     
                        // {    
                        //     unlink('public/products/'.$old_server_img);
                        //     $file1->move(FCPATH.'public/products/',$newName1);               
                        // }
                        // else
                        // {
                        //     $file1->move(FCPATH.'public/products/',$newName1);
                        // }                    
                }
            }
             else
             {
                $newName1 = $old_server_img;
             }
             if($_FILES['inner_image']['name'] != '')
             {
                if(isset($_FILES['inner_image']))
                {
                    $newName2 = $file2->getRandomName();    
                    $file2->move(FCPATH.'public/products/',$newName2);  
                        // if($old_inner_img != '')     
                        // {    
                        //     unlink('public/products/'.$old_inner_img);
                        //     $file2->move(FCPATH.'public/products/',$newName2);               
                        // }
                        // else
                        // {
                        //     $file2->move(FCPATH.'public/products/',$newName2);
                        // }                    
                }
            }
             else
             {
                $newName2 = $old_inner_img;
             }
             if($_FILES['product_image']['name'] != '')
             {
                if(isset($_FILES['product_image']))
                {
                    $newName3 = $file3->getRandomName();  
                    $file3->move(FCPATH.'public/products/',$newName3);    
                        // if($old_products_img != '')     
                        // {    
                        //     unlink('public/products/'.$old_products_img);
                        //     $file3->move(FCPATH.'public/products/',$newName3);               
                        // }
                        // else
                        // {
                        //     $file3->move(FCPATH.'public/products/',$newName3);
                        // }                    
                }
            }
             else
             {
                $newName3 = $old_products_img;
             }
           
            $data = $this->request->getVar();
            $data['image'] = $newName;
            $data['server_image'] = $newName1;
            $data['inner_image'] = $newName2;
            $data['product_image'] = $newName3;
            $data['updated_date'] = $date;
            //print_r($data);exit;
            if($this->innerProductModel->update($id,$data) == true)
            {
                session()->setTempdata('success','Product Updated',2);
                return redirect()->to(base_url()."/dashboard/viewInnerProducts");
            }
       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->innerProductModel->find($id);
       // $data['edit_data'] = $this->productsModel->find($id);
        echo view('admin/editInnerProduct',$data);
    }
    public function deleteInnerProduct($id=null)
    {
        if($this->innerProductModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewInnerProducts");
        }
    }
    //product rules
    public function viewInnerProductRules($id=null)
    {
       
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['product_rules'] = $this->innerRulesModel->where('product_id',$id)->findall();   
        $data['id']=$id;
        $data['product_name'] = $this->innerProductModel->find($id);
       

        return view('admin/viewProductRules',$data);
    }
    public function addProductRule($id=null)
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $data =[
                        'product_id' => $this->request->getVar('id'),
                        
                        'description'=> $this->request->getVar('description'),
                        'created_date' => $date,
                        
                    ];
          if($this->innerRulesModel->insert($data))
          {
            session()->setTempdata('success','Rules added successfully',3);
            return redirect()->to(base_url()."/dashboard/viewInnerProductRules/".$id);
          }
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        $data['id']=$id;

        return view('admin/addProductRule',$data);
    }
    
    //product inner page details
    public function viewInnerProductsDetails($id=null)
    {
         if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->innerRulesModel->find($id);
        $data['product_name'] = $this->innerProductModel->find($sid);

        echo view('admin/editProductRule',$data);
    }

    /***************Blogs************* */

    public function viewBlogs()
    {
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);

        $data['blogs'] = $this->blogModel->orderBy("id", "asc")->findall();   
       
        echo view('admin/viewBlog',$data);
    }
    public function addBlog()
    {
        $data = [];
        $data['validation'] = null; 
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
                $file = $this->request->getFile('blog_image');
                $file1 = $this->request->getFile('banner_image');
                $file2 = $this->request->getFile('blog_writer_image');

				
                if($_FILES['blog_image']['name'] != '')
                {
                    if(isset($_FILES['blog_image']))
                    {
                    $newName = $file->getRandomName(); 
                    $file->move(FCPATH.'public/blogs/',$newName); 
                    }
                }        
                if($_FILES['banner_image']['name'] != '')
                {
                    if(isset($_FILES['banner_image']))
                    {
                    $newName1 = $file1->getRandomName(); 
                    $file1->move(FCPATH.'public/blogs/',$newName1); 
                    }
                } 
                if($_FILES['blog_writer_image']['name'] != '')
                {
                    if(isset($_FILES['blog_writer_image']))
                    {
                    $newName2 = $file2->getRandomName(); 
                    $file2->move(FCPATH.'public/blogs/',$newName2); 
                    }
                }            
                    $data = $this->request->getVar();
                    $data['blog_image'] = $newName;
                    $data['banner_image'] = $newName1;
                    $data['url'] = url_title($this->request->getVar('blog_name'));
                    $data['created_at'] = $date;                 
                    if($this->blogModel->insert($data))
                    {
                        session()->setTempdata('success','Blog added successfully',3);
                        return redirect()->to(base_url()."/dashboard/viewBlogs");
                    }
                       
                
           
        }
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);        
        
        echo view('admin/addBlog',$data);
        
    }
    public function editBlog($id=null)
    {
        $data['blog'] = $this->blogModel->find($id); 
        //print_r($data);exit;
        $date=date('Y-m-d H:i:s');
        if($this->request->getMethod() == 'post')
        {
            $old_blog = $data['blog']['blog_image'];
            $old_blog1 = $data['blog']['banner_image'];
            $old_blog2 = $data['blog']['blog_writer_image'];

            $file = $this->request->getFile('blog_image');
            $file1 = $this->request->getFile('banner_image');
            $file2 = $this->request->getFile('blog_writer_image');

            
            if($_FILES['blog_image']['name'] != '')
            {
                if(isset($_FILES['blog_image']))
                {
                   $newName = $file->getRandomName();
                   $file->move(FCPATH.'public/blogs/',$newName);
                }                                       
                  
            } 
             else
             {
                $newName = $old_blog;
             }
             if($_FILES['banner_image']['name'] != '')
            {
                if(isset($_FILES['banner_image']))
                {
                   $edit_newName  = $file1->getRandomName();
                   $file1->move(FCPATH.'public/blogs/',$edit_newName);
                }                                       
                  
            } 
             else
             {
                $edit_newName = $old_blog1;
             }
             if($_FILES['blog_writer_image']['name'] != '')
            {
                if(isset($_FILES['blog_writer_image']))
                {
                   $newName1 = $file2->getRandomName();
                   $file2->move(FCPATH.'public/blogs/',$newName1);
                }                                       
                  
            } 
             else
             {
                $newName1 = $old_blog2;
             }

             $data = $this->request->getVar();
             $data['blog_image'] = $newName;
             $data['banner_image'] = $edit_newName;   
             $data['blog_writer_image'] = $newName1;    

             $data['url'] = url_title($this->request->getVar('blog_name'));         
             $data['updated_at'] = $date;
                
                // print_r($data);die;
                 if($this->blogModel->update($id,$data) == true)
                    {
                        session()->setTempdata('success','Blog Updated',2);
                       return redirect()->to(base_url()."/dashboard/viewBlogs");
                    }

       }
        
        if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
        $uniid = session()->get('logged_user');
        $data['userdata'] = $this->dModel->getLoggedUserData($uniid);
        
        $data['edit_data']=$this->blogModel->find($id);
        echo view('admin/editBlog',$data);
    }
    public function deleteBlog($id=null)
    {
        if($this->blogModel->where('id',$id)->delete())
        {
            session()->setTempdata('success',' Selected Row Deleted Successfully',2);
            return redirect()->to(base_url()."/dashboard/viewBlogs");
        }
    }

    
    public function abstractPage(){
		if(!session()->has('logged_user'))
        {
            return redirect()->to(base_url()."/Admin");
        }
				
        if($this->request->getMethod() == 'post'){
			$data = $this->request->getVar();
            if ($this->request->getVar('editabstract') == 'Yes'){
				//update 
				$editId = $this->request->getVar('editabstract_id');
				if ($this->abstractpageModel->update($editId, $data)) {
					session()->setTempdata('success', 'Abstract updated successfully', 3);
				} else {
					session()->setTempdata('error', 'Failed to update Abstract', 3);
				}
				return redirect()->to(base_url() . "/dashboard/abstractpage");
			}else{
				if($this->abstractpageModel->insert($data)){
					session()->setTempdata('success','Abstract added successfully',3);
					return redirect()->to(base_url()."/dashboard/abstractpage");
				}else {
					session()->setTempdata('error', 'Failed to update Abstract', 3);;
					return redirect()->to(base_url()."/dashboard/abstractpage");
				}
			}
		}
		
		$data['abstractsdata'] = $this->abstractpageModel->findAll();
		 
		//abstractpageModel
		return view("admin/abstractPage", $data);
	}
	public function editAbstractPage($id){
		$data['abstractsdata'] = $this->abstractpageModel->find($id);
		return view("admin/editAbstractPage", $data);
	}
	
	public function addAbstractPage(){
		return view("admin/addAbstractPage");
	}
	
	public function deleteAbstractPage($id){
		if ($this->abstractpageModel->delete($id)) {
            session()->setTempdata('success', 'Abstract deleted successfully', 3);
        } else {
            session()->setTempdata('error', 'Failed to delete abstract', 3);
        }
        return redirect()->to(base_url() . "/dashboard/abstractpage");
	}
	
    
    
}