<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\SettingsModel;
use App\Models\ProgramModel;
use App\Models\SpeakerCategoryModel;
use App\Models\ProgramSpeakersDataModel;
use App\Models\SeoModel;



class Programs extends BaseController
{
    public $programModel;
    public $speakerCategoryModel;
    public $programSpeakersDataModel;
    public $settingsModel;
    public $session;
    public $seoModel;
    

    public function __construct()
    {
        helper('form');
       // helper('captcha');
       $this->programModel = new ProgramModel();
       $this->speakerCategoryModel = new SpeakerCategoryModel();
       $this->programSpeakersDataModel = new ProgramSpeakersDataModel();
       $this->settingsModel  = new SettingsModel();
       $this->session = session();        
       $this->seoModel = new SeoModel();
        
    }
    public function index()
    {
        $data['programs'] = $this->programModel->orderBy("id", "asc")->findall();   
        $data['program'] = $this->programModel->orderBy('id','desc')->find();   
        $program = $this->programModel->orderBy('id','desc')->find();  
        foreach($program as $prog_data); 
        $data['program_id']=$prog_data['id'];
        $data['settings'] = $this->settingsModel->find(1);
        $data['speaker_cat'] = $this->speakerCategoryModel->where('status',1)->orderBy("id", "asc")->findall();   
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	


        echo view('programs',$data);
    }
    public function day($url)
    {
        $data['programs'] = $this->programModel->orderBy("id", "asc")->findall();   
        $data['program'] = $this->programModel->where('url',$url)->find();   
        $program = $this->programModel->where('url',$url)->orderBy('id','desc')->find();  
        foreach($program as $prog_data); 
        $data['program_id']=$prog_data['id'];

        $data['settings'] = $this->settingsModel->find(1);
        $data['speaker_cat'] = $this->speakerCategoryModel->where('status',1)->orderBy("id", "asc")->findall();   
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	


        echo view('programs',$data);
    }
    public function details($url)
    {
        $data['program_details'] = $this->programsModel->where('url',$url)->find(); 
        $data['programs'] = $this->programsModel->orderBy("id", "desc")->findall();   
        $data['settings'] = $this->settingsModel->find(1);
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	

        echo view('program_details',$data);
    }
    
    
}
