<?php
namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\RegisterModel; 
use App\Models\ContactInfoModel;
use App\Models\ContentModel;
use App\Models\RegistrationDate;
use App\Models\RegistrationTypeModel;
use App\Models\AddOnsModel;
use App\Models\RegisterSubmitModel;
use App\Models\RegGuidelinesModel;
use App\Models\CountriesModel;
use App\Models\SeoModel;
use App\Models\CouponsModel;
use App\Models\SponsorshipModel;
use App\Models\BrochuresModel;
use App\Models\SettingsModel;
use App\Models\ProgramModel;


class Register extends controller
{
    public $registerModel;
    public $session;
    public $email;
    public $contactInfoModel;
    public $contentModel;
    public $registrationDate;
    public $registrationTypeModel;
    public $addOnsModel;
    public $registerSubmitModel;
    public $regGuidelinesModel;
    public $countriesModel;
    public $seoModel;
    public $couponsModel;
    public $sponsorshipModel;
    public $brochuresModel;
	 public $settingsModel;
	 public $ProgramModel;
	 

    public function __construct()
    {
        helper('form');
        $this->registerModel = new RegisterModel();
        $this->session = \Config\Services::session();
        $this->email = \Config\Services::email();
        $this->contactInfoModel = new ContactInfoModel();
        $this->contentModel= new ContentModel();
        $this->registrationDate = new RegistrationDate();
		 $this->settingsModel  = new SettingsModel();
        $this->registrationTypeModel = new RegistrationTypeModel();
        $this->addOnsModel = new AddOnsModel();
        $this->registerSubmitModel = new RegisterSubmitModel();
        $this->regGuidelinesModel = new RegGuidelinesModel();        
        $this->countriesModel = new CountriesModel();
        $this->seoModel = new SeoModel();
        $this->couponsModel = new CouponsModel();
		$this->settingsModel  = new SettingsModel();
        date_default_timezone_set('America/Chicago');
        $recaptcha = service('recaptcha');
        $this->sponsorshipModel = new SponsorshipModel();
        $this->brochuresModel = new BrochuresModel();
		$this->ProgramModel = new ProgramModel();


    }
    public function index($url=null)
    {
        $data = [];
        $data['validation'] = null; 
        if($this->request->getMethod() == 'post')
        {    $rules = [
            'name'=>'required',
            'email'=>'required|valid_email',
            ];
            if($this->validate($rules))
            {
             $data = $this->request->getVar();
			 if($this->request->getVar('applied_coupon')!="")
			 {
             $discount_percentage = $this->couponsModel->where('coupon_code',$this->request->getVar('applied_coupon'))->get()->getRowArray();
             

			 $data['discount_percentage'] = $discount_percentage['discount_percentage'];
			}
             $rawamount = $this->request->getVar('reg_amount_info');
             $accamount = $this->request->getVar('acc_amount_info');
			 if($rawamount!='')
			 {
             $data['reg_type_fee'] = $rawamount;
			 }
			 else
			 {
				 $data['reg_type_fee'] = 0;
				 
			 }
			 if($accamount!="")
			 {
             $data['add_on'] = $accamount;
			 }
			 else
			 {
				  $data['add_on'] = 0;
				 
			 }
            //  $tax = round($rawamount*(3.5))/100;
            //  $data['tax'] = $tax;
             $data['total'] = $rawamount + $accamount;
             $data['created_at'] = date("Y-m-d h:i:s", strtotime("-30 minutes"));
             
             //print_r($data);   exit;  
             if($this->registerSubmitModel->insert($data))
             {
				$last_insert_id = $this->registerSubmitModel->getInsertID();
                $order_id = $last_insert_id;
                //$orderid =  $this->session->set('orderid',$order_id);
                $user_data = $this->registerSubmitModel->where('id',$order_id)->find();
				//foreach($user_data as $udata);
				
				//echo $udata['name'];
				$data['registerdata'] = $this->registerSubmitModel->where('id',$order_id)->find(); 
				$data['programs'] = $this->ProgramModel->find(); 
				$data['settings'] = $this->settingsModel->find(1);
				
				$url = "https://linkinscience.com/phpemailer/conference-registration.php";
				$client = \Config\Services::curlrequest();
				$data['received_url'] = base_url();
				$newresponse = $client->request('POST', $url, [
					'form_params' => $data
				]);

				$responseData = $newresponse->getBody();
				return view('confirmregister',$data);
				exit;
				
				
                //echo $this->registerSubmitModel->getLastQuery();exit;
                include_once FCPATH . "vendor/sendmail/vendor/autoload.php";
                $API_KEY="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";
                $email = new \SendGrid\Mail\Mail(); 
                $content = view('layouts/register_email',['user_data' => $data]);
                $email->setFrom("manasaimmadi@prodigit.in", "Linkinsciences");
                $email->setSubject("Linkinsciences Registeration Details");
                $email->addTo('manasaimmadi@prodigit.in',$this->request->getVar('first_name'));
                $email->addContent("text/plain", "Regisration Details");
                $email->addContent("text/html", $content);
                //$sendgrid = new \SendGrid(getenv($API_KEY));
                $apiKey = ($API_KEY);
                $sendgrid = new \SendGrid($apiKey);
                try {                  
                  $response = $sendgrid->send($email);
                } catch (Exception $e) {
                    echo 'Caught exception: '. $e->getMessage() ."\n";
                }             
               
                $sendgrid = new \SendGrid(getenv($API_KEY));
                if($sendgrid->send($email))
                {
                    $this->session->setTempData('success','Registration submitted',3);
                    return redirect()->to(current_url());
                }
             }
             else
             {
                $this->session->setTempData('error','Sorry! unable to create account',3);
                return redirect()->to(current_url());
             }  
            }
            else
            {
                //echo "else";exit;
                $data['validation'] = $this->validator;
            }          
        }
             
        $data['reg_dates'] = $this->registrationDate->orderBy("id", "asc")->findall();   
        $data['registration_type'] = $this->registrationTypeModel->orderBy("id", "asc")->findall();   
        $data['addons'] = $this->addOnsModel->orderBy("id", "asc")->findall();   
        $data['country_list'] = $this->countriesModel->orderBy("name", "asc")->findall();   
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	
		
        $data['currency_type']=$url;
		$data['programs'] = $this->ProgramModel->find(); 
		$data['settings'] = $this->settingsModel->find(1);
        return view('registeration',$data);
        
    }
    public function dollar()
    {
        $data = [];
        $data['validation'] = null; 
        if($this->request->getMethod() == 'post')
        {    $rules = [
            'name'=>'required',
            'email'=>'required|valid_email',
            ];
            if($this->validate($rules))
            {
             
             $data = $this->request->getVar();
             $rawamount = $this->request->getVar('reg_amount_info');
             $accamount = $this->request->getVar('acc_amount_info');
             $data['rawamount'] = $rawamount;
             $data['accamount'] = $accamount;
             $tax = round($rawamount*(3.5))/100;
             $data['tax'] = $tax;
             $data['total'] = $rawamount + $tax + $accamount;
             $data['created_at'] = date('Y-m-d',time());    
             //print_r($data);exit;   
             if($this->registerSubmitModel->insert($data))
             {
				 
                include_once FCPATH . "vendor/sendmail/vendor/autoload.php";

                $API_KEY="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";
  
                $email = new \SendGrid\Mail\Mail(); 
                $email->setFrom("manasaimmadi@prodigit.in", "manasa");
                $email->setSubject("Waiting For Approval");
                $email->addTo('manasaimmadi@prodigit.in','manasamahesh');
                $email->addContent("text/plain", "Waiting For Approval");
                $email->addContent(
                    "text/html", "<strong>Account Details</strong>"
                );
                //$sendgrid = new \SendGrid(getenv($API_KEY));
                $apiKey = ($API_KEY);
                $sendgrid = new \SendGrid($apiKey);
                try {
                    $response = $sendgrid->send($email);
                   // print $response->statusCode() . "\n";
                   // print_r($response->headers());
                   // print $response->body() . "\n";
                } catch (Exception $e) {
                    echo 'Caught exception: '. $e->getMessage() ."\n";
                }
                 
                $sendgrid = new \SendGrid(getenv($API_KEY));
                if($sendgrid->send($email))
                {
                    $this->session->setTempData('success','Registration submitted',3);
                    return redirect()->to(current_url());
                }
             }
             else
             {
                $this->session->setTempData('error','Sorry! unable to create account',3);
                return redirect()->to(current_url());
             }  
            }
            else
            {
                //echo "else";exit;
                $data['validation'] = $this->validator;
            }          
        }
             
        $data['reg_dates'] = $this->registrationDate->orderBy("id", "asc")->findall();   
        $data['registration_type'] = $this->registrationTypeModel->orderBy("id", "asc")->findall();   
        $data['addons'] = $this->addOnsModel->orderBy("id", "asc")->findall();  
		$data['programs'] = $this->ProgramModel->find(); 		
       
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	
	   
		 $data['settings'] = $this->settingsModel->find(1);

        return view('registeration',$data);
    }
	public function confirmation()
	{
		
	}
    public function reg_price()
   {
    $reg_amount = $this->request->getVar('reg_amount');
    
    //$tax = round($reg_amount*(3.5))/100;
    $array[] = ['registration_fee' => $reg_amount];
     json_encode([
        'data' => $array
    ]);
    echo $reg_amount;

   }
   public function acc_price()
   {
    $acc_amount = $this->request->getVar('acc_amount');
    $reg_amount = $this->request->getVar('reg_amount');
    
    echo $acc_amount+$reg_amount;

   }
   public function couponCal()
    {
        $user_id = $this->session->user_id;
        $coupon = $this->request->getVar('coupon');
        $payable = $this->request->getVar('payable');
        
        $date=date('Y-m-d');
        $coupon_data_info = $this->couponsModel->where('coupon_code',$coupon)->get()->getResultArray();
    //    echo $this->couponsModel->getLastQuery();
    //    print_r($coupon_data_info);exit;
        if(count($coupon_data_info) !=0)
        {
            foreach($coupon_data_info as $coupon_data);
            $discounted_amount = ($payable*$coupon_data['discount_percentage'])/100;
            $after_discount = $payable-$discounted_amount;
            $array[] = ['discount' => $coupon_data['discount_percentage'],'discounted_amount'=>$discounted_amount,'after_discount'=>$after_discount,];
            return json_encode([
                'data' => $array
            ]);
        }
        else
        {
            echo "<b style='color:red;font-size:18px;'>coupon expired</b>";
        }
        
        //echo count($coupon_data);

    }
    public function couponStatus()
    {
        $user_id = $this->session->user_id;
        $coupon = $this->request->getVar('coupon');
        $date=date('Y-m-d');
        if($coupon != '')
        {
        $coupon_data_info = $this->couponsModel->where('coupon_code',$coupon)->get()->getResultArray();
        if(count($coupon_data_info) !=0)
        {
            foreach($coupon_data_info as $coupon_data1);
           echo "<b style='color:green;font-size:16x;'>Coupon Applied</b>";            
        }
        else
        {
            echo "<b style='color:red;font-size:16px;'>Coupon Expired !!</b>";
        }
    }
    else
    {
        echo "<b style='color:red;font-size:16px;'>Please Enter Coupon Code!!</b>";
    }
    }
	public function registration_guidelines()
    {
	   $data['settings'] = $this->settingsModel->find(1);
		$data['reg_guidelines'] = $this->regGuidelinesModel->orderBy("id", "asc")->findall();   
		
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	
		
		$data['programs'] = $this->ProgramModel->find(); 
		echo view('guidelines',$data);
    }
	
    public function exhibitor_sponsorship()
    {
      if($this->request->getMethod() == 'post')
       {
        $data = $this->request->getVar();
        $file = $this->request->getFile('logo');
               
               if($_FILES['logo']['name'] != '')
               {
                   if(isset($_FILES['logo']))
                   {
                   $newName = $file->getRandomName(); 
                   $file->move(FCPATH.'public/sponsorship/',$newName); 
                   }
               }   
            $data['logo'] = $newName;
        if($this->sponsorshipModel->insert($data))
        {
            $this->session->setTempData('success','Successfully Submitted, we will contact you shortly..',3);
            return redirect()->to(current_url());
        }
    }
	$data['settings'] = $this->settingsModel->find(1);
    $data['country_list'] = $this->countriesModel->orderBy("name", "asc")->findall();   
    $data['sponsor_guide'] = $this->brochuresModel->find(1);   
    $data['programs'] = $this->ProgramModel->find();	
    
	$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	

    echo view('exhibitor_sponsor',$data);    
   }
}