<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\CommitteeModel;
use App\Models\SettingsModel;
use App\Models\SeoModel;
use App\Models\ProgramModel;



class ScientificCommittee extends BaseController
{
  
    public $committeeModel;
    public $settingsModel;
    public $session;
    public $seoModel;
    public $ProgramModel;

    public function __construct()
    {
        helper('form');
      
        $this->committeeModel = new CommitteeModel();
        $this->settingsModel  = new SettingsModel();
        $this->session = session();
        $this->seoModel = new SeoModel();
        $this->ProgramModel = new ProgramModel();
        
    }
	
    public function index()
    {
		$currentyear = '2024';
        $data['scientific_committee'] = $this->committeeModel
											->where('year', $currentyear)
											->where('status','1')
											->orderBy("id", "desc")
											->findall();   
        $data['settings'] = $this->settingsModel->find(1);
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	
		
		$data['programs'] = $this->ProgramModel->find();
        $data['currentyear'] = $currentyear;	
		
        echo view('scientific_committee',$data);
    }
	public function indexYears($year){
		$currentyear = $year;
        $data['scientific_committee'] = $this->committeeModel
											->where('year', $currentyear)
											->where('status','1')
											->orderBy("id", "desc")
											->findall();
											
        $data['settings'] = $this->settingsModel->find(1);
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	
		
		$data['programs'] = $this->ProgramModel->find();
        $data['currentyear'] = $currentyear;	
		
        echo view('scientific_committee',$data);
	}
    public function member($url)
    {
        $data['member_details'] = $this->committeeModel->where('url',$url)->find();   
        $data['settings'] = $this->settingsModel->find(1);
        
		$uri = service('uri');
		$current_path = $uri->getPath();
		$ltrimcurrent_path = ltrim($current_path, '/');

		$data['meta_content'] = $this->seoModel->where('page_name', $ltrimcurrent_path)->first();
		if (empty($data['meta_content'])) {
			$path_segments = explode('/', $ltrimcurrent_path);
			foreach ($path_segments as $path_segment) {
				$data['meta_content'] = $this->seoModel->where('page_name', $path_segment)->first();
				if (!empty($data['meta_content'])) {
					break;
				}
			}
		}
		if (empty($data['meta_content'])) {
			$data['meta_content'] = $this->seoModel->where('page_name', 'Home')->first();
		}	
		
		$data['programs'] = $this->ProgramModel->find(); 
        echo view('scientific_member',$data);
    }

    
}
