<?php $page_session = \Config\Services::session();
$db = db_connect();?>
<?= $this->extend('layouts/admin_base');?>
<?= $this->section('admin_content');?>

  <div class="page-breadcrumb">
    <div class="row">
        <div class="col-12 d-flex no-block align-items-center">
            <h5 class="page-title">
                <a href="<?=base_url();?>/dashboard" class="breadcrumb-link">Dashboard</a> >> 
                <a href="<?=base_url();?>/dashboard/viewProgram">Programs</a> (
                <?php 
                    $pnddname = $db->table('pd_tbl_programs_dtl')->where('id',$program_id)->get()->getRowArray();
                    echo $pnddname['program_name'];
                ?>) >> 
                <a href="<?=base_url();?>/dashboard/viewSpeakerCat/<?=$program_id;?>" class="breadcrumb-link">Speaker Category</a> (
                <?php                                                   
                    $pname = $db->table('pd_tbl_speaker_category_dtl')->where('id',$speaker_cat_id)->get()->getRowArray();
                    echo $pname['speaker_cat_name'];
                ?>)
            </h5>               
        </div>
    </div>
  </div>
           
  <div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div align="right">
                <a href="<?=base_url();?>/dashboard/addSpeakerData/<?=$program_id;?>/<?=$speaker_cat_id;?>">
                    <button class="btn btn-primary">Add</button>
                </a>
            </div>
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                    <?php 
                        if($page_session->getTempdata('success')):   
                            echo $page_session->getTempdata('success');
                        endif;
                        if($page_session->getTempdata('error')):
                            echo $page_session->getTempdata('error');
                        endif;
                    ?>
                    <div id="updated_message"></div> 
                    </h5>
                    <div class="table-responsive">
                        <form action="<?=base_url('dashboard/deleteall_clients');?>" method="post">
                            <table id="zero_config" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Priority Position</th>
                                        <th>Name</th>
                                        <th>Time</th>
                                        <th>Details</th>
                                        <th>Image</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($speaker_data as $sp_data){ ?>
                                    <tr>                                   
                                        <td><?=$i;?></td>
                                        <td> 
                                            <input id="order_id_<?=$sp_data['id'];?>" value="<?=$sp_data['priority_id'];?>" onchange="myFunction(<?=$sp_data['id'];?>);">
                                            <input type="hidden" id="prog_id_<?=$sp_data['id'];?>" value="<?=$sp_data['id'];?>">
                                            <input type="hidden" id="pid" value="<?=$sp_data['program_id'];?>"> 
                                            <input type="hidden" id="catid" value="<?=$speaker_cat_id;?>">
                                        </td>                                      
                                        <td><?=$sp_data['speaker_name'];?></td>
                                        <td><?=$sp_data['program_time'];?></td>
                                        <td><?=$sp_data['designation'];?>,<?=$sp_data['country'];?></td>
                                        <td><img src="<?=base_url();?>/public/programs/<?=$sp_data['profile_pic'];?>" width="100px"></td>
                                        <td>
                                            <a href="<?= base_url();?>/dashboard/editSpeakerData/<?=$sp_data['id']; ?>">
                                                <img src="<?=base_url();?>/public/admin/assets/images/pencil-edit-button.svg" width="20px">
                                            </a>
                                            <a href="<?= base_url();?>/dashboard/deleteSpekerData/<?=$sp_data['id']; ?>/<?=$sp_data['program_id'];?>/<?=$sp_data['speaker_cat_id'];?>">
                                                <img src="<?=base_url();?>/public/admin/assets/images/delete-icon.png" width="20px">
                                            </a>
                                            
                                            <button type="button" class="btn btn-primary btn-sm mt-2" data-toggle="modal" data-target="#changeDayModal" onclick="setSpeakerId(<?=$sp_data['id'];?>)">
                                                Change Day
                                            </button>
                                        </td>
                                    </tr>
                                    <?php $i++; } ?>
                                </tbody>
                            </table>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>

 <!-- Modal -->
<div class="modal fade" id="changeDayModal" tabindex="-1" role="dialog" aria-labelledby="changeDayModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content relative" style="position:relative;">
            <div class="modal-header">
                <h5 class="modal-title" id="changeDayModalLabel">Change Day</h5>
            </div>
            <div class="modal-body">
                <select class="form-select w-full" aria-label="Program Selection" style="width: 100%; padding: 10px 15px;" id="program_select">
                    <?php if (!empty($programsarray)) : ?>
                        <?php foreach($programsarray as $program): ?>
                            <option value="<?= htmlspecialchars($program['id'], ENT_QUOTES, 'UTF-8'); ?>"
                                <?php if ($program['id'] == $pnddname['id']): ?> 
                                    selected disabled
                                <?php endif; ?>
                            >
                                <?= htmlspecialchars($program['program_name'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <option value="" disabled>No programs available</option>
                    <?php endif; ?>
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="closeBtn">Close</button>
                <button type="button" class="btn btn-primary" id="saveChangesBtn" onclick="saveDayChange()">Save changes</button>
            </div>

            <!-- Loading overlay -->
            <div id="loadingOverlay" style="display:none; position:absolute; top:0; left:0; width:100%; height:100%; background:rgba(0, 0, 0, 0.5); z-index:1000; text-align:center; color:#fff; font-size:20px;">
                Loading...
            </div>
        </div>
    </div>
</div>



<script>
    let selectedSpeakerId = null;

	function setSpeakerId(speakerId) {
		selectedSpeakerId = speakerId;
	}

	function saveDayChange() {
		const selectedProgramId = document.getElementById('program_select').value;

		// Show loading overlay and disable buttons
		document.getElementById('loadingOverlay').style.display = 'block';
		document.getElementById('saveChangesBtn').disabled = true;
		document.getElementById('closeBtn').disabled = true;

		$.ajax({
			type: 'POST',
			url: '<?= base_url(); ?>/dashboard/changeSpeakerDay',
			data: {
				speaker_id: selectedSpeakerId,
				program_id: selectedProgramId
			},
			success: function(response) {
				const res = JSON.parse(response);  // Parse the JSON response from the server

				// Hide loading overlay and enable buttons
				document.getElementById('loadingOverlay').style.display = 'none';
				document.getElementById('saveChangesBtn').disabled = false;
				document.getElementById('closeBtn').disabled = false;

				if (res.status === 'success') {
					alert(res.message);  // Display success message in an alert box
					location.reload();  // Reload the page after alert is closed
				} else {
					alert(res.message);  // Display error message in an alert box
				}

				$('#changeDayModal').modal('hide');  // Close the modal
			},
			error: function(xhr, status, error) {
				// Hide loading overlay and enable buttons in case of error
				document.getElementById('loadingOverlay').style.display = 'none';
				document.getElementById('saveChangesBtn').disabled = false;
				document.getElementById('closeBtn').disabled = false;

				alert('An error occurred. Please try again.');  // Fallback error message if AJAX fails
			}
		});
	}

    function myFunction(id) {
        const order_id = $('#order_id_' + id).val();
        const prog_id = $('#prog_id_' + id).val();
        const pid = $('#pid').val();
        const catid = $('#catid').val();
        
        $.ajax({
            type: 'GET',
            url: '<?= base_url(); ?>/dashboard/updateOrder',
            data: {
                order_id: order_id,
                prog_id: prog_id,
                pid: pid,
                catid: catid
            },
            success: function(response) {
                document.getElementById('updated_message').innerHTML = response;
                alert(jQuery(response).text());
            }
        });
    }
</script>

<?= $this->endSection();?>
